/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.client;

import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptSounds;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

public class WindsweptSoundProvider
extends SoundDefinitionsProvider {
    public WindsweptSoundProvider(GatherDataEvent event) {
        super(event.getGenerator(), "windswept", event.getExistingFileHelper());
    }

    public void registerSounds() {
        this.register(WindsweptSounds.MUSIC_DISC_RAIN, "records/rain", SoundDefinition.Sound::stream);
        this.register(WindsweptSounds.MUSIC_DISC_SNOW, "records/snow", SoundDefinition.Sound::stream);
        this.register(WindsweptSounds.MUSIC_DISC_BUMBLEBEE, "records/bumblebee", SoundDefinition.Sound::stream);
    }

    private void register(RegistryObject<SoundEvent> soundEvent, String location, Consumer<SoundDefinition.Sound> consumer) {
        SoundDefinition.Sound sound = WindsweptSoundProvider.sound((ResourceLocation)Windswept.REGISTRY_HELPER.prefix(location));
        if (consumer != null) {
            consumer.accept(sound);
        }
        this.add((SoundEvent)soundEvent.get(), WindsweptSoundProvider.definition().with(sound));
    }
}

