/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEntities;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class WindsweptLootTableProvider
extends LootTableProvider {
    private final Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet> blockTables = Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_);
    private final Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet> entityTables = Pair.of(Entities::new, (Object)LootContextParamSets.f_81415_);
    private final Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet> chestTables = Pair.of(Chests::new, (Object)LootContextParamSets.f_81421_);

    public WindsweptLootTableProvider(GatherDataEvent event) {
        super(event.getGenerator());
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of(this.blockTables, this.entityTables, this.chestTables);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static <T> Iterable<T> getContent(IForgeRegistry<T> entry) {
        return entry.getValues().stream().filter(i -> entry.getKey(i) != null && "windswept".equals(entry.getKey(i).m_135827_())).collect(Collectors.toSet());
    }

    private static class Chests
    extends ChestLoot {
        private Chests() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            Chests.register("grove_weathered_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.SNOWY_SPROUTS.get())).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.SNOW_BOOTS.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WOODEN_BUCKET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WOODEN_POWDER_SNOW_BUCKET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WILD_BERRIES.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41981_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41863_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.HOLLY_SAPLING.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.COOKED_GOAT.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))), builder);
            Chests.register("chestnut_weathered_house", LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41865_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42780_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.CHESTNUT_LOG.get())).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41863_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptBlocks.CHESTNUT_SAPLING.get())).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42801_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WOODEN_BUCKET.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)20.0f))))), builder);
        }

        private static void register(String name, LootTable.Builder lootTable, BiConsumer<ResourceLocation, LootTable.Builder> builder) {
            builder.accept(Windswept.REGISTRY_HELPER.prefix("chests/" + name), lootTable);
        }
    }

    private static class Entities
    extends EntityLoot {
        private Entities() {
        }

        protected void addTables() {
            this.m_124371_((EntityType)WindsweptEntities.CHILLED.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> WindsweptItems.FROZEN_FLESH.get()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-2.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42732_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> WindsweptItems.MUSIC_DISC_SNOW.get())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13120_)))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return WindsweptLootTableProvider.getContent(ForgeRegistries.ENTITY_TYPES);
        }
    }

    private static class Blocks
    extends BlockLoot {
        private Blocks() {
        }

        protected void addTables() {
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_HOLLY_LOG.get());
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_HOLLY_WOOD.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_LOG.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_WOOD.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_PLANKS.get());
            this.m_124175_((Block)WindsweptBlocks.HOLLY_SLAB.get(), x$0 -> Blocks.m_124290_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.HOLLY_STAIRS.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_FENCE.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_FENCE_GATE.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_PRESSURE_PLATE.get());
            this.m_124175_((Block)WindsweptBlocks.HOLLY_DOOR.get(), BlockLoot::m_124137_);
            this.m_124288_((Block)WindsweptBlocks.HOLLY_TRAPDOOR.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_BUTTON.get());
            this.m_124288_((Block)((RegistryObject)WindsweptBlocks.HOLLY_SIGNS.getFirst()).get());
            this.m_124288_((Block)((RegistryObject)WindsweptBlocks.HOLLY_SIGNS.getSecond()).get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_SAPLING.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_HOLLY_SAPLING.get());
            this.m_124175_((Block)WindsweptBlocks.HOLLY_BEEHIVE.get(), x$0 -> Blocks.m_124300_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.HOLLY_LADDER.get());
            this.m_124288_((Block)WindsweptBlocks.VERTICAL_HOLLY_PLANKS.get());
            this.bookshelf((Block)WindsweptBlocks.HOLLY_BOOKSHELF.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_BOARDS.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_CABINET.get());
            this.m_124175_((Block)WindsweptBlocks.HOLLY_VERTICAL_SLAB.get(), Blocks::createVerticalSlabItemTable);
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_HOLLY_POST.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_POST.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_CHEST.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_TRAPPED_CHEST.get());
            this.m_124175_((Block)WindsweptBlocks.HOLLY_LEAVES.get(), b -> Blocks.m_124157_((Block)b, (Block)((Block)WindsweptBlocks.HOLLY_SAPLING.get()), (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_124066_).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)Blocks.m_236224_((ItemLike)b, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.HOLLY_BERRIES.get())))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-6.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.m_124288_((Block)WindsweptBlocks.HOLLY_HEDGE.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_LEAF_CARPET.get());
            this.leafPile((Block)WindsweptBlocks.HOLLY_LEAF_PILE.get());
            this.m_124288_((Block)WindsweptBlocks.HOLLY_BERRY_BASKET.get());
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_CHESTNUT_LOG.get());
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_CHESTNUT_WOOD.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_LOG.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_WOOD.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_PLANKS.get());
            this.m_124175_((Block)WindsweptBlocks.CHESTNUT_SLAB.get(), x$0 -> Blocks.m_124290_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_STAIRS.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_FENCE.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_FENCE_GATE.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_PRESSURE_PLATE.get());
            this.m_124175_((Block)WindsweptBlocks.CHESTNUT_DOOR.get(), BlockLoot::m_124137_);
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_TRAPDOOR.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_BUTTON.get());
            this.m_124288_((Block)((RegistryObject)WindsweptBlocks.CHESTNUT_SIGNS.getFirst()).get());
            this.m_124288_((Block)((RegistryObject)WindsweptBlocks.CHESTNUT_SIGNS.getSecond()).get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_SAPLING.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_CHESTNUT_SAPLING.get());
            this.m_124175_((Block)WindsweptBlocks.CHESTNUT_BEEHIVE.get(), x$0 -> Blocks.m_124300_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_LADDER.get());
            this.m_124288_((Block)WindsweptBlocks.VERTICAL_CHESTNUT_PLANKS.get());
            this.bookshelf((Block)WindsweptBlocks.CHESTNUT_BOOKSHELF.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_BOARDS.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_CABINET.get());
            this.m_124175_((Block)WindsweptBlocks.CHESTNUT_VERTICAL_SLAB.get(), Blocks::createVerticalSlabItemTable);
            this.m_124288_((Block)WindsweptBlocks.STRIPPED_CHESTNUT_POST.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_POST.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_CHEST.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_TRAPPED_CHEST.get());
            this.m_124175_((Block)WindsweptBlocks.CHESTNUT_LEAVES.get(), b -> Blocks.m_124157_((Block)b, (Block)((Block)WindsweptBlocks.CHESTNUT_SAPLING.get()), (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_124066_).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)Blocks.m_236224_((ItemLike)b, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.CHESTNUTS.get())))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-4.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_HEDGE.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_LEAF_CARPET.get());
            this.leafPile((Block)WindsweptBlocks.CHESTNUT_LEAF_PILE.get());
            this.m_124288_((Block)WindsweptBlocks.CHESTNUT_CRATE.get());
            this.m_124288_((Block)WindsweptBlocks.ROASTED_CHESTNUT_CRATE.get());
            this.m_124288_((Block)WindsweptBlocks.SNOW_BRICKS.get());
            this.m_124288_((Block)WindsweptBlocks.SNOW_BRICK_STAIRS.get());
            this.m_124175_((Block)WindsweptBlocks.SNOW_BRICK_SLAB.get(), x$0 -> Blocks.m_124290_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.SNOW_BRICK_WALL.get());
            this.m_124175_((Block)WindsweptBlocks.SNOW_BRICK_VERTICAL_SLAB.get(), Blocks::createVerticalSlabItemTable);
            this.m_124288_((Block)WindsweptBlocks.PACKED_ICE_BRICKS.get());
            this.m_124288_((Block)WindsweptBlocks.CHISELED_PACKED_ICE_BRICKS.get());
            this.m_124288_((Block)WindsweptBlocks.PACKED_ICE_BRICK_STAIRS.get());
            this.m_124175_((Block)WindsweptBlocks.PACKED_ICE_BRICK_SLAB.get(), x$0 -> Blocks.m_124290_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.PACKED_ICE_BRICK_WALL.get());
            this.m_124175_((Block)WindsweptBlocks.PACKED_ICE_BRICK_VERTICAL_SLAB.get(), Blocks::createVerticalSlabItemTable);
            this.m_124288_((Block)WindsweptBlocks.BLUE_ICE_BRICKS.get());
            this.m_124288_((Block)WindsweptBlocks.CHISELED_BLUE_ICE_BRICKS.get());
            this.m_124288_((Block)WindsweptBlocks.BLUE_ICE_BRICK_STAIRS.get());
            this.m_124175_((Block)WindsweptBlocks.BLUE_ICE_BRICK_SLAB.get(), x$0 -> Blocks.m_124290_((Block)x$0));
            this.m_124288_((Block)WindsweptBlocks.BLUE_ICE_BRICK_WALL.get());
            this.m_124175_((Block)WindsweptBlocks.BLUE_ICE_BRICK_VERTICAL_SLAB.get(), Blocks::createVerticalSlabItemTable);
            this.m_124288_((Block)WindsweptBlocks.POLISHED_DEEPSLATE_PRESSURE_PLATE.get());
            this.m_124288_((Block)WindsweptBlocks.POLISHED_DEEPSLATE_BUTTON.get());
            this.tallFlower((Block)WindsweptBlocks.RED_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.PINK_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.BLUE_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.WHITE_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.YELLOW_ROSE_BUSH.get());
            this.tallFlower((Block)WindsweptBlocks.WITHER_ROSE_BUSH.get());
            this.m_124175_((Block)WindsweptBlocks.SNOWY_SPROUTS.get(), x$0 -> Blocks.m_124286_((ItemLike)x$0));
            this.m_124288_((Block)WindsweptBlocks.RED_ROSE.get());
            this.m_124288_((Block)WindsweptBlocks.PINK_ROSE.get());
            this.m_124288_((Block)WindsweptBlocks.BLUE_ROSE.get());
            this.m_124288_((Block)WindsweptBlocks.WHITE_ROSE.get());
            this.m_124288_((Block)WindsweptBlocks.YELLOW_ROSE.get());
            this.m_124288_((Block)WindsweptBlocks.FOXGLOVE.get());
            this.m_124288_((Block)WindsweptBlocks.BLUEBELLS.get());
            this.m_124288_((Block)WindsweptBlocks.NIGHTSHADE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_RED_ROSE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_PINK_ROSE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_BLUE_ROSE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_WHITE_ROSE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_YELLOW_ROSE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_FOXGLOVE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_BLUEBELLS.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_NIGHTSHADE.get());
            this.m_124252_((Block)WindsweptBlocks.POTTED_SNOWY_SPROUTS.get());
            this.m_124175_((Block)WindsweptBlocks.WILD_BERRY_BUSH.get(), b -> (LootTable.Builder)Blocks.m_236221_((ItemLike)b, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SweetBerryBushBlock.f_57244_, 2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)WindsweptItems.WILD_BERRIES.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)))));
            this.m_124288_((Block)WindsweptBlocks.WILD_BERRY_BASKET.get());
            this.m_124147_((Block)WindsweptBlocks.WILD_BERRY_BUSH_PIPS.get(), (ItemLike)WindsweptItems.WILD_BERRY_PIPS.get());
            this.m_124288_((Block)WindsweptBlocks.RED_MUSHROOM_BASKET.get());
            this.m_124288_((Block)WindsweptBlocks.BROWN_MUSHROOM_BASKET.get());
            this.m_124288_((Block)WindsweptBlocks.GLOW_SHROOM_BASKET.get());
            this.m_124288_((Block)WindsweptBlocks.ICE_SHEET.get());
            this.m_124288_((Block)WindsweptBlocks.FROZEN_FLESH_BLOCK.get());
        }

        private void bookshelf(Block block) {
            this.m_124175_(block, b -> Blocks.m_176042_((Block)b, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
        }

        private void tallFlower(Block block) {
            this.m_124175_(block, b -> Blocks.m_124161_((Block)b, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
        }

        private void leafPile(Block block) {
            this.m_124175_(block, b -> Blocks.m_236227_((Block)b, (LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))));
        }

        public Iterable<Block> getKnownBlocks() {
            return WindsweptLootTableProvider.getContent(ForgeRegistries.BLOCKS);
        }

        private static LootTable.Builder createVerticalSlabItemTable(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)Blocks.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE)))))));
        }
    }
}

