/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.mixin;

import com.rosemods.windswept.common.enchantment.curse.SlippingCurseEnchantment;
import com.rosemods.windswept.common.item.SnowBootsItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    private void onChangedBlock(BlockPos pos, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (SnowBootsItem.shouldRemoveSnowSpeed(entity.f_19853_.m_8055_(entity.m_20097_()), entity)) {
            SnowBootsItem.removeSnowSpeed(entity);
        }
        SnowBootsItem.tryAddSnowSpeed(entity);
        SlippingCurseEnchantment.attemptDamageBoots(entity);
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    private void checkFallDamage(double p_20990_, boolean p_20991_, BlockState state, BlockPos pos, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (!entity.f_19853_.f_46443_ && p_20991_ && entity.f_19789_ > 0.0f) {
            SnowBootsItem.removeSnowSpeed(entity);
            SnowBootsItem.tryAddSnowSpeed(entity);
            SlippingCurseEnchantment.attemptDamageBoots(entity);
        }
    }
}

