/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.other;

import com.rosemods.windswept.common.item.wooden_bucket.WoodenBucketItem;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.rosemods.windswept.integration.neapolitan.WindsweptMilkCauldronInteractions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.fml.ModList;

public final class WindsweptCauldronInteractions {
    public static void registerCauldronInteractions() {
        CauldronInteraction.f_175607_.put((Item)WindsweptItems.WOODEN_BUCKET.get(), WindsweptCauldronInteractions::emptyWaterCauldron);
        CauldronInteraction.f_175606_.put((Item)WindsweptItems.WOODEN_WATER_BUCKET.get(), WindsweptCauldronInteractions::fillWaterCauldron);
        CauldronInteraction.f_175607_.put((Item)WindsweptItems.WOODEN_WATER_BUCKET.get(), WindsweptCauldronInteractions::fillWaterCauldron);
        CauldronInteraction.f_175609_.put((Item)WindsweptItems.WOODEN_BUCKET.get(), WindsweptCauldronInteractions::emptySnowCauldron);
        CauldronInteraction.f_175606_.put((Item)WindsweptItems.WOODEN_POWDER_SNOW_BUCKET.get(), WindsweptCauldronInteractions::fillSnowCauldron);
        CauldronInteraction.f_175609_.put((Item)WindsweptItems.WOODEN_POWDER_SNOW_BUCKET.get(), WindsweptCauldronInteractions::fillSnowCauldron);
        CauldronInteraction.f_175607_.put((Item)WindsweptItems.SNOW_BOOTS.get(), CauldronInteraction.f_175615_);
        if (ModList.get().isLoaded("neapolitan")) {
            WindsweptMilkCauldronInteractions.registerCauldronInteractions();
        }
    }

    public static InteractionResult fillCauldron(Block filledBlock, SoundEvent sound, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (!level.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)WoodenBucketItem.getEmpty(stack, player, hand)));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            level.m_46597_(pos, (BlockState)filledBlock.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
            level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static InteractionResult fillWaterCauldron(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        return WindsweptCauldronInteractions.fillCauldron(Blocks.f_152476_, SoundEvents.f_11778_, state, level, pos, player, hand, stack);
    }

    private static InteractionResult fillSnowCauldron(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        return WindsweptCauldronInteractions.fillCauldron(Blocks.f_152478_, SoundEvents.f_144076_, state, level, pos, player, hand, stack);
    }

    public static InteractionResult emptyCauldron(ItemLike filled, SoundEvent sound, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3) {
            if (!level.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)WoodenBucketItem.getFilled(stack, filled, player)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult emptyWaterCauldron(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        return WindsweptCauldronInteractions.emptyCauldron(() -> WindsweptItems.WOODEN_WATER_BUCKET.get(), SoundEvents.f_11781_, state, level, pos, player, hand, stack);
    }

    private static InteractionResult emptySnowCauldron(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        return WindsweptCauldronInteractions.emptyCauldron(() -> WindsweptItems.WOODEN_POWDER_SNOW_BUCKET.get(), SoundEvents.f_144089_, state, level, pos, player, hand, stack);
    }
}

