/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.other.events;

import com.rosemods.windswept.common.effect.ThornsEffect;
import com.rosemods.windswept.common.entity.Chilled;
import com.rosemods.windswept.common.item.SnowBootsItem;
import com.rosemods.windswept.common.item.wooden_bucket.WoodenMilkBucketItem;
import com.rosemods.windswept.core.WindsweptConfig;
import com.rosemods.windswept.core.other.WindsweptDataProcessors;
import com.rosemods.windswept.core.other.tags.WindsweptBlockTags;
import com.rosemods.windswept.core.other.tags.WindsweptEntityTypeTags;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptEntities;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.core.other.tags.BlueprintEntityTypeTags;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="windswept")
public class WindsweptEntityEvents {
    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (attacker != null && entity != null && entity.m_21023_((MobEffect)WindsweptEffects.THORNS.get())) {
            ThornsEffect.doThornsDamage(entity, attacker);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        if (stack.m_150930_((Item)WindsweptItems.WOODEN_BUCKET.get()) && target.m_6095_().m_204039_(BlueprintEntityTypeTags.MILKABLE)) {
            Animal animal;
            if (target instanceof Animal && (animal = (Animal)target).m_6162_()) {
                return;
            }
            WoodenMilkBucketItem.milkAnimal(player, hand, stack);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        SignBlockEntity sign;
        BlockState state = event.getPlacedBlock();
        if (state.m_204336_(WindsweptBlockTags.DEFAULT_WHITE_TEXT) && (sign = (SignBlockEntity)event.getLevel().m_7702_(event.getPos())) != null) {
            sign.m_59739_(DyeColor.WHITE);
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        Mob mob;
        if (((Boolean)WindsweptConfig.COMMON.rabbitLitters.get()).booleanValue() && (mob = event.getParentA()) instanceof Rabbit) {
            Rabbit parent = (Rabbit)mob;
            mob = event.getParentB();
            if (mob instanceof Rabbit) {
                Rabbit parentB = (Rabbit)mob;
                Level level = parent.m_20193_();
                int litter = level.f_46441_.m_188503_(3);
                for (int i = 0; i < litter; ++i) {
                    Rabbit baby = (Rabbit)EntityType.f_20517_.m_20615_(level);
                    if (baby == null) continue;
                    baby.m_6863_(true);
                    baby.m_29733_(level.f_46441_.m_188499_() ? parent.m_29719_() : parentB.m_29719_());
                    baby.m_7678_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), 0.0f, 0.0f);
                    level.m_7967_((Entity)baby);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_150930_((Item)WindsweptItems.WILD_BERRIES.get()) && ItemSubRegistryHelper.areModsLoaded((String[])new String[]{"berry_good"})) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        Mob mob = event.getEntity();
        LevelAccessor level = event.getLevel();
        MobSpawnType reason = event.getSpawnReason();
        if (mob != null && level instanceof ServerLevel && event.getResult() != Event.Result.DENY && mob.m_20186_() > 60.0 && (reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION) && level.m_204166_(mob.m_20183_()).m_203656_(Tags.Biomes.IS_SNOWY)) {
            if (mob.m_6095_() == EntityType.f_20501_) {
                if ((mob = mob.m_21406_((EntityType)WindsweptEntities.CHILLED.get(), true)) instanceof Chilled) {
                    Chilled chilled = (Chilled)mob;
                    chilled.cncCompat(level.m_213780_());
                }
            } else if (mob.m_6095_() == EntityType.f_20524_ && ((Boolean)WindsweptConfig.COMMON.strays.get()).booleanValue() && (mob = mob.m_21406_(EntityType.f_20481_, true)) != null) {
                mob.m_21008_(InteractionHand.MAIN_HAND, Items.f_42411_.m_7968_());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (SnowBootsItem.canSpawnSnowSpeedParticle(entity)) {
            SnowBootsItem.spawnSnowSpeedParticle(entity);
        }
        if (entity.m_6095_().m_204039_(WindsweptEntityTypeTags.CONVERT_TO_CHILLED) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            IDataManager data = (IDataManager)mob;
            if (!mob.f_19853_.f_46443_ && mob.m_6084_() && !mob.m_21525_()) {
                if (((Boolean)data.getValue(WindsweptDataProcessors.IS_FREEZE_CONVERTING)).booleanValue()) {
                    WindsweptEntityEvents.ammendData(data, WindsweptDataProcessors.FREEZE_CONVERT_TIME, -1);
                    if ((Integer)data.getValue(WindsweptDataProcessors.FREEZE_CONVERT_TIME) < 0) {
                        mob.m_21406_((EntityType)WindsweptEntities.CHILLED.get(), true);
                        data.clean();
                        if (!mob.m_20067_()) {
                            mob.f_19853_.m_5898_(null, 1048, mob.m_20183_(), 0);
                        }
                    }
                } else if (mob.f_146808_) {
                    WindsweptEntityEvents.ammendData(data, WindsweptDataProcessors.POWDER_SNOW_TIME, 1);
                    if ((Integer)data.getValue(WindsweptDataProcessors.POWDER_SNOW_TIME) >= 140) {
                        data.setValue(WindsweptDataProcessors.FREEZE_CONVERT_TIME, (Object)300);
                        data.setValue(WindsweptDataProcessors.IS_FREEZE_CONVERTING, (Object)true);
                    }
                } else {
                    data.setValue(WindsweptDataProcessors.POWDER_SNOW_TIME, (Object)-1);
                }
            }
        }
    }

    private static void ammendData(IDataManager data, TrackedData<Integer> tracked, int change) {
        data.setValue(tracked, (Object)((Integer)data.getValue(tracked) + change));
    }
}

