/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry;

import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptFeatures;
import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="windswept", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WindsweptBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Windswept.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome CHESTNUT_FOREST = HELPER.createBiome("chestnut_forest", () -> WindsweptBiomes.chestnutForest(false));
    public static final BiomeSubRegistryHelper.KeyedBiome SNOWY_CHESTNUT_FOREST = HELPER.createBiome("snowy_chestnut_forest", () -> WindsweptBiomes.chestnutForest(true));

    private static Biome chestnutForest(boolean snowy) {
        MobSpawnSettings.Builder spawns = WindsweptBiomes.baseChestnutSpawns();
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        float temp = snowy ? -0.3f : 0.3f;
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)WindsweptFeatures.Placements.TALL_FERNS.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)WindsweptFeatures.Placements.CHESTNUT_FERNS.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)WindsweptFeatures.Placements.CHESTNUT_TREES_COMMON.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)WindsweptFeatures.Placements.TALL_BIRCH.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)(snowy ? WindsweptFeatures.Placements.WHITE_ROSE_BUSH : WindsweptFeatures.Placements.BLUE_ROSE_BUSH).getHolder().get());
        return new Biome.BiomeBuilder().m_47597_(snowy ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(WindsweptBiomes.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(OverworldBiomes.f_194839_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static MobSpawnSettings.Builder baseChestnutSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 12, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 12, 4, 4));
        return spawns;
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

