/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry;

import com.google.common.collect.ImmutableList;
import com.rosemods.windswept.common.block.wild_berry.WildBerryBushBlock;
import com.rosemods.windswept.common.world.gen.feature.BluebellsFeature;
import com.rosemods.windswept.common.world.gen.feature.NightshadeFeature;
import com.rosemods.windswept.common.world.gen.feature.SnowySproutsFeature;
import com.rosemods.windswept.common.world.gen.tree.decorator.BranchDecorator;
import com.rosemods.windswept.common.world.gen.tree.foliage_placer.ChestnutFoliagePlacer;
import com.rosemods.windswept.common.world.gen.tree.trunk_placer.ChestnutTrunkPlacer;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.DualNoiseProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class WindsweptFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"windswept");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SNOWY_SPROUTS_PATCH = FEATURES.register("snowy_sprouts_patch", SnowySproutsFeature::new);
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> NIGHTSHADE_PATCH = FEATURES.register("nightshade_patch", NightshadeFeature::new);
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> BLUEBELL_PATCH = FEATURES.register("bluebell_patch", BluebellsFeature::new);

    public static class TreePlacements {
        public static final RegistryObject<PlacedFeature> HOLLY_TREES_BEES = Placements.register("holly_trees_bees_checked", TreeFeatures.HOLLY_TREES_BEES, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        public static final RegistryObject<PlacedFeature> HOLLY_ON_SNOW = Placements.register("holly_on_snow_checked", TreeFeatures.HOLLY_TREES, (List<PlacementModifier>)net.minecraft.data.worldgen.placement.TreePlacements.f_195380_);
        public static final RegistryObject<PlacedFeature> CHESTNUT_TREES_BEES = Placements.register("chestnut_trees_bees_checked", TreeFeatures.CHESTNUT_TREES_BEES, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});

        public static List<PlacementModifier> treePlacement(PlacementModifier modifier) {
            return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)VegetationPlacements.f_195420_).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).build();
        }
    }

    public static class TreeFeatures {
        public static final RegistryObject<ConfiguredFeature<?, ?>> HOLLY_TREES = Features.CONFIGURED_FEATURES.register("holly_trees_checked", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.HOLLY_TREE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> HOLLY_TREES_BEES = Features.CONFIGURED_FEATURES.register("holly_trees_bees_checked", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.HOLLY_TREE_BEES));
        public static final RegistryObject<ConfiguredFeature<?, ?>> CHESTNUT_TREES = Features.CONFIGURED_FEATURES.register("chestnut_trees_checked", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.CHESTNUT_TREE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> CHESTNUT_TREES_BEES = Features.CONFIGURED_FEATURES.register("chestnut_trees_bees_checked", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)Configs.CHESTNUT_TREE_BEES));
    }

    public static class Placements {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"windswept");
        public static final RegistryObject<PlacedFeature> RED_ROSE = Placements.createPlantPatch("red_rose", 16, Features.RED_ROSE);
        public static final RegistryObject<PlacedFeature> WHITE_ROSE = Placements.createPlantPatch("white_rose", 32, Features.WHITE_ROSE);
        public static final RegistryObject<PlacedFeature> PINK_ROSE = Placements.createPlantPatch("pink_rose", 32, Features.PINK_ROSE);
        public static final RegistryObject<PlacedFeature> BLUE_ROSE = Placements.createPlantPatch("blue_rose", 32, Features.BLUE_ROSE);
        public static final RegistryObject<PlacedFeature> YELLOW_ROSE = Placements.createPlantPatch("yellow_rose", 24, Features.YELLOW_ROSE);
        public static final RegistryObject<PlacedFeature> FOXGLOVE = Placements.createPlantPatch("foxglove", 6, Features.FOXGLOVE);
        public static final RegistryObject<PlacedFeature> BLUEBELLS = Placements.createPlantPatch("bluebells", 3, Features.BLUEBELLS);
        public static final RegistryObject<PlacedFeature> WHITE_ROSE_BUSH = Placements.createPlantPatch("white_rose_bush", 12, Features.WHITE_ROSE_BUSH);
        public static final RegistryObject<PlacedFeature> BLUE_ROSE_BUSH = Placements.createPlantPatch("blue_rose_bush", 12, Features.BLUE_ROSE_BUSH);
        public static final RegistryObject<PlacedFeature> YELLOW_ROSE_BUSH = Placements.createPlantPatch("yellow_rose_bush", 12, Features.YELLOW_ROSE_BUSH);
        public static final RegistryObject<PlacedFeature> NIGHTHSADE = Placements.createPlantPatch("nightshade", 360, Features.NIGHTHSADE);
        public static final RegistryObject<PlacedFeature> WILD_BERRY_BUSH = Placements.createPlantPatch("wild_berry_bush", 32, Features.WILD_BERRY_BUSH);
        public static final RegistryObject<PlacedFeature> WILD_BERRY_BUSH_COMMON = Placements.createPlantPatch("wild_berry_bush_common", 5, Features.WILD_BERRY_BUSH);
        public static final RegistryObject<PlacedFeature> SNOWY_SPROUTS = Placements.createPlantPatch("snowy_sprouts", 1, Features.SNOWY_SPROUTS);
        public static final RegistryObject<PlacedFeature> TALL_FERNS = Placements.register("tall_ferns", VegetationFeatures.f_195189_, List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final RegistryObject<PlacedFeature> CHESTNUT_FERNS = Placements.register("chestnut_ferns", Features.CHESTNUT_FERNS, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> HOLLY_TREES = Placements.register("holly_trees", Features.HOLLY_TREES, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> GROVE_HOLLY_TREES = Placements.register("grove_holly_trees", Features.GROVE_HOLLY_TREES, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)9, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> GROVE_SPRUCE_TREES = Placements.register("grove_spruce_trees", VegetationFeatures.f_195160_, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> RARE_SNOWY_HOLLY_TREES = Placements.register("rare_snowy_holly_trees", Features.GROVE_HOLLY_TREES, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> CHESTNUT_TREES = Placements.register("chestnut_trees", Features.CHESTNUT_TREES, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> CHESTNUT_TREES_COMMON = Placements.register("chestnut_trees_common", Features.CHESTNUT_TREES, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)9, (float)0.1f, (int)1)));
        public static final RegistryObject<PlacedFeature> TALL_BIRCH = Placements.register("tall_birch", VegetationFeatures.f_195162_, TreePlacements.treePlacement(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1)));

        private static RegistryObject<PlacedFeature> createPlantPatch(String name, int onceEvery, RegistryObject<ConfiguredFeature<?, ?>> feature) {
            return Placements.register(name, feature, new PlacementModifier[]{RarityFilter.m_191900_((int)onceEvery), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        }

        public static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... placementModifiers) {
            return Placements.register(name, configuredFeature, List.of(placementModifiers));
        }

        public static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)configuredFeature.getHolder().get(), placementModifiers));
        }

        public static RegistryObject<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature(configuredFeature, placementModifiers));
        }
    }

    public static class Features {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"windswept");
        public static final RegistryObject<ConfiguredFeature<?, ?>> RED_ROSE = CONFIGURED_FEATURES.register("red_rose", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.RED_ROSE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> WHITE_ROSE = CONFIGURED_FEATURES.register("white_rose", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.WHITE_ROSE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> PINK_ROSE = CONFIGURED_FEATURES.register("pink_rose", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.PINK_ROSE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> BLUE_ROSE = CONFIGURED_FEATURES.register("blue_rose", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.BLUE_ROSE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> YELLOW_ROSE = CONFIGURED_FEATURES.register("yellow_rose", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.YELLOW_ROSE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> FOXGLOVE = CONFIGURED_FEATURES.register("foxglove", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.FOXGLOVE));
        public static final RegistryObject<ConfiguredFeature<?, ?>> CHESTNUT_FERNS = CONFIGURED_FEATURES.register("chestnut_ferns", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.CHESTNUT_FERNS));
        public static final RegistryObject<ConfiguredFeature<?, ?>> WHITE_ROSE_BUSH = CONFIGURED_FEATURES.register("white_rose_bush", () -> new ConfiguredFeature(Feature.f_65762_, (FeatureConfiguration)Configs.WHITE_ROSE_BUSH));
        public static final RegistryObject<ConfiguredFeature<?, ?>> BLUE_ROSE_BUSH = CONFIGURED_FEATURES.register("blue_rose_bush", () -> new ConfiguredFeature(Feature.f_65762_, (FeatureConfiguration)Configs.BLUE_ROSE_BUSH));
        public static final RegistryObject<ConfiguredFeature<?, ?>> YELLOW_ROSE_BUSH = CONFIGURED_FEATURES.register("yellow_rose_bush", () -> new ConfiguredFeature(Feature.f_65762_, (FeatureConfiguration)Configs.YELLOW_ROSE_BUSH));
        public static final RegistryObject<ConfiguredFeature<?, ?>> BLUEBELLS = CONFIGURED_FEATURES.register("bluebells", () -> new ConfiguredFeature((Feature)BLUEBELL_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<?, ?>> NIGHTHSADE = CONFIGURED_FEATURES.register("nightshades", () -> new ConfiguredFeature((Feature)NIGHTSHADE_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<?, ?>> WILD_BERRY_BUSH = CONFIGURED_FEATURES.register("wild_berry_bush", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)Configs.WILD_BERRY_BUSH));
        public static final RegistryObject<ConfiguredFeature<?, ?>> SNOWY_SPROUTS = CONFIGURED_FEATURES.register("snowy_sprouts", () -> new ConfiguredFeature((Feature)SNOWY_SPROUTS_PATCH.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<?, ?>> HOLLY_TREES = CONFIGURED_FEATURES.register("holly_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)TreePlacements.HOLLY_TREES_BEES.getHolder().get(), 0.33333334f)), (Holder)TreePlacements.HOLLY_TREES_BEES.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<?, ?>> GROVE_HOLLY_TREES = CONFIGURED_FEATURES.register("grove_holly_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)TreePlacements.HOLLY_ON_SNOW.getHolder().get(), 0.33333334f)), (Holder)TreePlacements.HOLLY_ON_SNOW.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<?, ?>> CHESTNUT_TREES = CONFIGURED_FEATURES.register("chestnut_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)TreePlacements.CHESTNUT_TREES_BEES.getHolder().get(), 0.33333334f)), (Holder)TreePlacements.CHESTNUT_TREES_BEES.getHolder().get())));
    }

    public static class Configs {
        public static final TreeConfiguration HOLLY_TREE = Configs.createHollyTree().m_68249_(List.of(BranchDecorator.create((Block)WindsweptBlocks.HOLLY_LOG.get(), 2))).m_68251_();
        public static final TreeConfiguration HOLLY_TREE_BEES = Configs.createHollyTree().m_68249_(List.of(new BeehiveDecorator(0.01f), BranchDecorator.create((Block)WindsweptBlocks.HOLLY_LOG.get(), 2))).m_68251_();
        public static final TreeConfiguration CHESTNUT_TREE = Configs.createChestnutTree().m_68249_(List.of(BranchDecorator.create((Block)WindsweptBlocks.CHESTNUT_LOG.get(), 4))).m_68251_();
        public static final TreeConfiguration CHESTNUT_TREE_BEES = Configs.createChestnutTree().m_68249_(List.of(new BeehiveDecorator(0.005f), BranchDecorator.create((Block)WindsweptBlocks.CHESTNUT_LOG.get(), 4))).m_68251_();
        public static final RandomPatchConfiguration RED_ROSE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.RED_ROSE.get()).m_49966_());
        public static final RandomPatchConfiguration WHITE_ROSE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.WHITE_ROSE.get()).m_49966_());
        public static final RandomPatchConfiguration PINK_ROSE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.PINK_ROSE.get()).m_49966_());
        public static final RandomPatchConfiguration BLUE_ROSE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.BLUE_ROSE.get()).m_49966_());
        public static final RandomPatchConfiguration YELLOW_ROSE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.YELLOW_ROSE.get()).m_49966_());
        public static final RandomPatchConfiguration FOXGLOVE = Configs.createPlantPatch(64, ((Block)WindsweptBlocks.FOXGLOVE.get()).m_49966_());
        public static final RandomPatchConfiguration WILD_BERRY_BUSH = Configs.createPlantPatch(32, (BlockState)((Block)WindsweptBlocks.WILD_BERRY_BUSH.get()).m_49966_().m_61124_((Property)WildBerryBushBlock.AGE, (Comparable)Integer.valueOf(2)));
        public static final RandomPatchConfiguration WHITE_ROSE_BUSH = Configs.createPlantPatch(32, ((Block)WindsweptBlocks.WHITE_ROSE_BUSH.get()).m_49966_());
        public static final RandomPatchConfiguration BLUE_ROSE_BUSH = Configs.createPlantPatch(32, ((Block)WindsweptBlocks.BLUE_ROSE_BUSH.get()).m_49966_());
        public static final RandomPatchConfiguration YELLOW_ROSE_BUSH = Configs.createPlantPatch(32, ((Block)WindsweptBlocks.YELLOW_ROSE_BUSH.get()).m_49966_());
        public static final RandomPatchConfiguration CHESTNUT_FERNS = FeatureUtils.m_206470_((int)4, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50035_))));

        private static RandomPatchConfiguration createPlantPatch(int tries, BlockState state) {
            return new RandomPatchConfiguration(tries, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new DualNoiseProvider(new InclusiveRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), new NormalNoise.NoiseParameters(-10, 1.0, new double[0]), 1.0f, 2345L, new NormalNoise.NoiseParameters(-3, 1.0, new double[0]), 1.0f, List.of(state)))));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createHollyTree() {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)WindsweptBlocks.HOLLY_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)WindsweptBlocks.HOLLY_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)2), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_161262_();
        }

        private static TreeConfiguration.TreeConfigurationBuilder createChestnutTree() {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)WindsweptBlocks.CHESTNUT_LOG.get())), (TrunkPlacer)new ChestnutTrunkPlacer(), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)WindsweptBlocks.CHESTNUT_LEAVES.get())), (FoliagePlacer)new ChestnutFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)2)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_161262_();
        }
    }
}

