/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.block.FriendsAndFoesOxidizable;
import com.faboslav.friendsandfoes.common.util.WaxableBlocksMap;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public final class OnUseOxidizable {
    public static InteractionResult onOxidizableUse(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult itemInHandUsageResult;
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        UseOnContext itemUsageContext = new UseOnContext(player, hand, hit);
        if (itemInHand instanceof HoneycombItem) {
            Optional<BlockState> possibleWaxedState = OnUseOxidizable.getWaxedState(blockState);
            if (possibleWaxedState.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockPos, itemStack);
                }
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                world.m_7731_(blockPos, possibleWaxedState.get(), 11);
                world.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)possibleWaxedState.get()));
                world.m_5898_(player, 3003, blockPos, 0);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        } else if (itemInHand instanceof AxeItem) {
            Optional<BlockState> possibleUnWaxedState = OnUseOxidizable.getUnWaxedState(blockState);
            Optional<BlockState> possibleOxidationState = FriendsAndFoesOxidizable.getDecreasedOxidationState(blockState);
            Optional<Object> possibleState = Optional.empty();
            if (possibleUnWaxedState.isPresent()) {
                world.m_5594_(player, blockPos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(player, 3004, blockPos, 0);
                possibleState = possibleUnWaxedState;
            } else if (possibleOxidationState.isPresent()) {
                world.m_5594_(player, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(player, 3005, blockPos, 0);
                possibleState = possibleOxidationState;
            }
            if (possibleState.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockPos, itemStack);
                }
                world.m_7731_(blockPos, (BlockState)possibleState.get(), 11);
                world.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)possibleState.get())));
                if (player != null) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if ((itemInHand instanceof HoneycombItem || itemInHand instanceof AxeItem) && (itemInHandUsageResult = itemInHand.m_6225_(itemUsageContext)).m_19077_()) {
            return itemInHandUsageResult;
        }
        return InteractionResult.PASS;
    }

    private static Optional<BlockState> getWaxedState(BlockState state) {
        return Optional.ofNullable((Block)WaxableBlocksMap.UNWAXED_TO_WAXED_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    private static Optional<BlockState> getUnWaxedState(BlockState state) {
        return Optional.ofNullable((Block)WaxableBlocksMap.WAXED_TO_UNWAXED_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }
}

