/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TuffGolemHeldItemFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemInHandRenderer heldItemRenderer;
    private final ItemRenderer itemRenderer;

    public TuffGolemHeldItemFeatureRenderer(RenderLayerParent<T, M> context, ItemInHandRenderer heldItemRenderer, ItemRenderer itemRenderer) {
        super(context);
        this.heldItemRenderer = heldItemRenderer;
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T tuffGolem, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (tuffGolem.m_21224_() || !((TuffGolemEntity)tuffGolem).isHoldingItem()) {
            return;
        }
        ItemStack itemStack = tuffGolem.m_6844_(EquipmentSlot.MAINHAND);
        BakedModel itemBakedModel = this.itemRenderer.m_174264_(itemStack, null, null, tuffGolem.m_19879_());
        float yItemOffset = itemBakedModel.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        float levitationOffset = Mth.m_14031_((float)(((float)((LivingEntity)tuffGolem).f_19797_ + tickDelta) / 10.0f + (float)Math.PI)) * 0.1f + 0.1f;
        float yOffset = levitationOffset + (0.85f - yItemOffset * 0.5f);
        float rotationAngle = (float)Math.toDegrees(animationProgress * 0.05f % ((float)Math.PI * 2));
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)yOffset, -0.575);
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(rotationAngle));
        this.heldItemRenderer.m_109322_(tuffGolem, itemStack, ItemTransforms.TransformType.GROUND, false, matrices, vertexConsumers, light);
        matrices.m_85849_();
    }
}

