/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class IceologerIceChunkEntity
extends Entity {
    private static final String OWNER_UUID_NBT_NAME = "OwnerUuid";
    private static final String TARGET_UUID_NBT_NAME = "TargetUuid";
    private static final String TICKS_UNTIL_FALL_NBT_NAME = "TicksUntilFall";
    private static final String IDLE_TICKS_NBT_NAME = "IdleTicks";
    private static final int MIN_FLYING_TICKS = 60;
    private static final int MAX_FLYING_TICKS = 100;
    private static final int MIN_IDLE_TICKS = 10;
    private static final int MAX_IDLE_TICKS = 20;
    private static final int SUMMON_TICKS = 30;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(IceologerIceChunkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(IceologerIceChunkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_FALL = SynchedEntityData.m_135353_(IceologerIceChunkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IDLE_TICKS = SynchedEntityData.m_135353_(IceologerIceChunkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private LivingEntity target;
    private int lifetimeTicks;
    private float summonAnimationProgress;
    private float lastSummonAnimationProgress;

    public IceologerIceChunkEntity(EntityType<? extends IceologerIceChunkEntity> entityType, Level world) {
        super(entityType, world);
        this.m_20331_(true);
        this.m_20242_(true);
        this.lifetimeTicks = 0;
        this.summonAnimationProgress = 0.0f;
        this.lastSummonAnimationProgress = 0.0f;
        this.playSummonSound();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
        this.f_19804_.m_135372_(TICKS_UNTIL_FALL, (Object)RandomGenerator.generateInt(60, 100));
        this.f_19804_.m_135372_(IDLE_TICKS, (Object)RandomGenerator.generateInt(10, 20));
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128403_(OWNER_UUID_NBT_NAME)) {
            this.setOwnerUuid(nbt.m_128342_(OWNER_UUID_NBT_NAME));
        }
        if (nbt.m_128403_(TARGET_UUID_NBT_NAME)) {
            this.setTargetUuid(nbt.m_128342_(TARGET_UUID_NBT_NAME));
        }
        if (nbt.m_128441_(TICKS_UNTIL_FALL_NBT_NAME)) {
            this.setTicksUntilFall(nbt.m_128451_(TICKS_UNTIL_FALL_NBT_NAME));
        }
        if (nbt.m_128441_(IDLE_TICKS_NBT_NAME)) {
            this.setIdleTicks(nbt.m_128451_(IDLE_TICKS_NBT_NAME));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.getOwnerUuid() != null) {
            nbt.m_128362_(OWNER_UUID_NBT_NAME, this.getOwnerUuid());
        }
        if (this.getTargetUuid() != null) {
            nbt.m_128362_(TARGET_UUID_NBT_NAME, this.getTargetUuid());
        }
        nbt.m_128405_(TICKS_UNTIL_FALL_NBT_NAME, this.getTicksUntilFall());
        nbt.m_128405_(IDLE_TICKS_NBT_NAME, this.getIdleTicks());
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.getOwnerUuid() != null && !this.m_9236_().m_5776_() && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.getOwnerUuid())) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    @Nullable
    public UUID getTargetUuid() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UUID)).orElse(null);
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(TARGET_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.getTargetUuid() != null && !this.m_9236_().m_5776_() && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.getTargetUuid())) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.target;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifetimeTicks == 10) {
            this.playSummonSound();
        } else if (this.lifetimeTicks == 40) {
            this.playAmbientSound();
        }
        ++this.lifetimeTicks;
        this.setSummonAnimationProgress();
        if (this.getTarget() != null && !this.m_9236_().m_5776_()) {
            Player playerTarget;
            if (this.getTarget().m_142389_() && ((playerTarget = (Player)this.getTarget()).m_5833_() || playerTarget.m_7500_())) {
                this.customDiscard();
                return;
            }
            if (this.getTicksUntilFall() > 0) {
                this.moveTowardsTarget();
            }
        }
        if (this.getTicksUntilFall() > 0) {
            this.setTicksUntilFall(this.getTicksUntilFall() - 1);
            return;
        }
        this.m_5997_(0.0, -0.05f, 0.0);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.f_19863_) {
            this.damageHitEntities();
            this.customDiscard();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getTicksUntilFall() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_FALL);
    }

    private void setTicksUntilFall(int ticksUntilFall) {
        this.f_19804_.m_135381_(TICKS_UNTIL_FALL, (Object)ticksUntilFall);
    }

    private int getIdleTicks() {
        return (Integer)this.f_19804_.m_135370_(IDLE_TICKS);
    }

    private void setIdleTicks(int idleTicks) {
        this.f_19804_.m_135381_(IDLE_TICKS, (Object)idleTicks);
    }

    private void damageHitEntities() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List hitEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
        for (LivingEntity hitEntity : hitEntities) {
            this.damage(hitEntity);
        }
    }

    private void damage(LivingEntity hitEntity) {
        LivingEntity livingEntity = this.getOwner();
        if (!hitEntity.m_6084_() || hitEntity.m_20147_() || hitEntity == livingEntity || livingEntity != null && livingEntity.m_7307_((Entity)hitEntity)) {
            return;
        }
        DamageSource damageSource = livingEntity == null ? DamageSource.f_19319_ : DamageSource.m_19367_((Entity)this, (Entity)livingEntity);
        hitEntity.m_6469_(damageSource, 12.0f);
        if (hitEntity.m_142079_()) {
            hitEntity.m_146917_(400);
        }
    }

    private void customDiscard() {
        this.playHitSound();
        this.spawnHitParticles();
        this.m_146870_();
    }

    public void moveTowardsTarget() {
        LivingEntity target = this.getTarget();
        if (target == null || !target.m_6084_() || target.m_20184_().m_82556_() < 1.0E-4) {
            return;
        }
        Vec3 targetPosition = new Vec3(target.m_20185_(), this.getYPositionWithHeightOffset(target.m_20186_(), this.getTarget().m_20206_()), target.m_20189_());
        Vec3 targetDirection = targetPosition.m_82546_(this.m_20182_()).m_82541_();
        this.m_20256_(targetDirection.m_82490_(0.2));
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private double getYPositionWithHeightOffset(double y, double height) {
        return Math.min(y + height * height, y + 6.0);
    }

    private SoundEvent getAmbientSound() {
        return FriendsAndFoesSoundEvents.ENTITY_ICE_CHUNK_AMBIENT.get();
    }

    private void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        this.m_5496_(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    private SoundEvent getHitSound() {
        return FriendsAndFoesSoundEvents.ENTITY_ICE_CHUNK_HIT.get();
    }

    private void playHitSound() {
        SoundEvent soundEvent = this.getHitSound();
        this.m_5496_(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    private SoundEvent getSummonSound() {
        return FriendsAndFoesSoundEvents.ENTITY_ICE_CHUNK_SUMMON.get();
    }

    private void playSummonSound() {
        SoundEvent soundEvent = this.getSummonSound();
        this.m_5496_(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    public void spawnHitParticles() {
        this.spawnParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50568_.m_49966_()), 16);
    }

    private void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level world = this.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)world).m_8767_(particleEffect, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public float getSummonAnimationProgress() {
        return this.summonAnimationProgress;
    }

    public void setSummonAnimationProgress() {
        this.lastSummonAnimationProgress = this.summonAnimationProgress;
        this.summonAnimationProgress = Math.min(1.0f, (float)this.lifetimeTicks / 30.0f);
    }

    public float getLastSummonAnimationProgress() {
        return this.lastSummonAnimationProgress;
    }

    public static IceologerIceChunkEntity createWithOwnerAndTarget(Level world, LivingEntity owner, LivingEntity target) {
        IceologerIceChunkEntity chunkEntity = new IceologerIceChunkEntity(FriendsAndFoesEntityTypes.ICE_CHUNK.get(), world);
        chunkEntity.setOwnerUuid(owner.m_20148_());
        chunkEntity.setTargetUuid(target.m_20148_());
        chunkEntity.m_6034_(target.m_20185_(), chunkEntity.getYPositionWithHeightOffset(target.m_20186_(), target.m_20206_()), target.m_20189_());
        return chunkEntity;
    }
}

