/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabBreedTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabDanceTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabGoToHomePositionTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLayEggTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLocateBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabTravelToBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabWaveTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FlyingRandomStroll;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public final class CrabBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super CrabEntity>>> SENSORS;
    private static final UniformInt WAVE_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        CrabBrain.addCoreActivities((Brain<CrabEntity>)brain);
        CrabBrain.addIdleActivities((Brain<CrabEntity>)brain);
        CrabBrain.addLayEggActivities((Brain<CrabEntity>)brain);
        CrabBrain.addDanceActivities((Brain<CrabEntity>)brain);
        CrabBrain.addWaveActivities((Brain<CrabEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<CrabEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get())));
    }

    private static void addLayEggActivities(Brain<CrabEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.CRAB_LAY_EGG.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabGoToHomePositionTask())), (Object)Pair.of((Object)1, (Object)((Object)new CrabLocateBurrowSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new CrabTravelToBurrowSpotTask())), (Object)Pair.of((Object)3, (Object)((Object)new CrabLayEggTask()))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addDanceActivities(Brain<CrabEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.CRAB_DANCE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabDanceTask()))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addWaveActivities(Brain<CrabEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.CRAB_WAVE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabWaveTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26368_, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object[])new Pair[]{Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)MemoryStatus.VALUE_ABSENT)}));
    }

    private static void addIdleActivities(Brain<CrabEntity> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(crab -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)((Object)new CrabBreedTask(FriendsAndFoesEntityTypes.CRAB.get(), 1.0f))), (Object)Pair.of((Object)2, (Object)new BabyFollowAdult(UniformInt.m_146622_((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FlyingRandomStroll(1.0f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivities(CrabEntity crab) {
        crab.m_6274_().m_21926_((List)ImmutableList.of((Object)FriendsAndFoesActivities.CRAB_LAY_EGG.get(), (Object)FriendsAndFoesActivities.CRAB_DANCE.get(), (Object)FriendsAndFoesActivities.CRAB_WAVE.get(), (Object)Activity.f_37979_));
    }

    public static void updateMemories(CrabEntity crab) {
        if (crab.hasEgg()) {
            crab.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)true);
        } else {
            crab.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get());
        }
        if (crab.isDancing() && !crab.m_6147_()) {
            crab.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)true);
        } else {
            crab.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get());
        }
    }

    public static void setWaveCooldown(CrabEntity crab) {
        crab.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)WAVE_COOLDOWN_PROVIDER.m_214085_(crab.m_217043_()));
    }

    public static Ingredient getTemptItems() {
        return Ingredient.m_204132_(FriendsAndFoesTags.CRAB_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(SensorType.f_26811_, SensorType.f_26812_, SensorType.f_26822_, FriendsAndFoesSensorTypes.CRAB_TEMPTATIONS.get());
        MEMORY_MODULES = List.of(MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148205_, MemoryModuleType.f_26377_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_26326_, MemoryModuleType.f_26368_, MemoryModuleType.f_26332_, FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get());
        WAVE_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)20, (int)40);
    }
}

