/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalFindInteractionTargetTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalWaitForPlayerTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public final class RascalBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super RascalEntity>>> SENSORS;
    public static final int NOD_COOLDOWN = 10;
    private static final UniformInt NOD_COOLDOWN_PROVIDER;
    private static final UniformInt AVOID_MEMORY_DURATION;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        RascalBrain.addCoreActivities((Brain<RascalEntity>)brain);
        RascalBrain.addIdleActivities((Brain<RascalEntity>)brain);
        RascalBrain.addWaitActivities((Brain<RascalEntity>)brain);
        RascalBrain.addAvoidActivities((Brain<RascalEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<RascalEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get())));
    }

    private static void addIdleActivities(Brain<RascalEntity> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new RascalFindInteractionTargetTask(6))), (Object)Pair.of((Object)0, RascalBrain.makeRandomWanderTask())));
    }

    private static void addWaitActivities(Brain<RascalEntity> brain) {
        brain.m_21895_(FriendsAndFoesActivities.RASCAL_WAIT.get(), 10, ImmutableList.of((Object)((Object)new RascalWaitForPlayerTask())), MemoryModuleType.f_26374_);
    }

    private static void addAvoidActivities(Brain<RascalEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.0f, (int)32, (boolean)true)), MemoryModuleType.f_26383_);
    }

    public static void updateActivities(RascalEntity rascal) {
        rascal.m_6274_().m_21926_((List)ImmutableList.of((Object)FriendsAndFoesActivities.RASCAL_WAIT.get(), (Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    private static RunOne<RascalEntity> makeRandomWanderTask() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.6f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void setNodCooldown(RascalEntity rascal) {
        rascal.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)NOD_COOLDOWN_PROVIDER.m_214085_(rascal.m_217043_()));
        RascalBrain.onCooldown(rascal);
    }

    public static boolean shouldRunAway(RascalEntity rascal) {
        return rascal.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get()).isPresent();
    }

    public static void onCooldown(RascalEntity rascal) {
        if (!RascalBrain.shouldRunAway(rascal)) {
            return;
        }
        if (rascal.m_8077_()) {
            return;
        }
        LivingEntity nearestTarget = rascal.m_6274_().m_21952_(MemoryModuleType.f_26374_).orElse(null);
        if (nearestTarget == null) {
            return;
        }
        RascalBrain.runAwayFrom(rascal, nearestTarget);
    }

    private static void runAwayFrom(RascalEntity rascal, LivingEntity target) {
        rascal.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        rascal.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        rascal.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        rascal.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)AVOID_MEMORY_DURATION.m_214085_(rascal.m_217043_()));
    }

    static {
        SENSORS = List.of(SensorType.f_26811_, SensorType.f_26812_);
        MEMORY_MODULES = List.of(MemoryModuleType.f_148205_, MemoryModuleType.f_26377_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26383_, MemoryModuleType.f_26374_, MemoryModuleType.f_148206_, MemoryModuleType.f_26367_, MemoryModuleType.f_26326_, FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get());
        NOD_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)10, (int)10);
        AVOID_MEMORY_DURATION = TimeUtil.m_145020_((int)10, (int)10);
    }
}

