/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemPressButtonTask
extends Behavior<CopperGolemEntity> {
    private static final float WITHING_DISTANCE = 2.0f;
    private int pressButtonTicks = 0;
    private int minPressButtonTick = 0;
    private int maxPressButtonTicks = 0;
    private boolean wasButtonPressed = false;
    private int heightDifference = 0;

    public CopperGolemPressButtonTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), MemoryStatus.VALUE_ABSENT), 100);
    }

    protected boolean shouldRun(ServerLevel world, CopperGolemEntity copperGolem) {
        return copperGolem.getButtonPos() != null && copperGolem.isButtonValidToBePressed(copperGolem.getButtonPos().m_122646_()) && copperGolem.getButtonPos().m_122646_().m_203195_((Position)copperGolem.m_20182_(), 2.0) && !copperGolem.m_21573_().m_26572_();
    }

    protected void run(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        this.pressButtonTicks = 0;
        this.wasButtonPressed = false;
        GlobalPos buttonPos = copperGolem.getButtonPos();
        if (buttonPos == null) {
            return;
        }
        this.heightDifference = buttonPos.m_122646_().m_123342_() - copperGolem.m_20183_().m_123342_();
        this.maxPressButtonTicks = this.heightDifference >= 1 ? CopperGolemAnimations.getPressButtonUpKeyframeAnimation(copperGolem.getAnimationSpeedModifier()).getAnimationLengthInTicks() : CopperGolemAnimations.getPressButtonDownKeyframeAnimation(copperGolem.getAnimationSpeedModifier()).getAnimationLengthInTicks();
        this.minPressButtonTick = copperGolem.m_217043_().m_216332_((int)((double)this.maxPressButtonTicks * 0.4), (int)((double)this.maxPressButtonTicks * 0.6));
    }

    protected boolean shouldKeepRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        return this.pressButtonTicks <= this.maxPressButtonTicks && !copperGolem.isOxidized();
    }

    protected void keepRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        ++this.pressButtonTicks;
        if (this.heightDifference >= 1) {
            copperGolem.startPressButtonUpAnimation();
        } else {
            copperGolem.startPressButtonDownAnimation();
        }
        if (copperGolem.getOxidationLevel().ordinal() >= WeatheringCopper.WeatherState.WEATHERED.ordinal() && (double)copperGolem.m_217043_().m_188501_() > 0.99) {
            copperGolem.setOxidationLevel(WeatheringCopper.WeatherState.OXIDIZED);
        }
        if (this.pressButtonTicks < this.minPressButtonTick) {
            return;
        }
        if (this.wasButtonPressed) {
            return;
        }
        GlobalPos buttonPos = copperGolem.getButtonPos();
        if (buttonPos == null) {
            return;
        }
        this.wasButtonPressed = this.tryToPressButton(copperGolem, buttonPos.m_122646_());
    }

    protected void finishRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        copperGolem.setPose(CopperGolemEntityPose.IDLE);
        copperGolem.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get());
        CopperGolemBrain.setPressButtonCooldown(copperGolem);
    }

    private boolean tryToPressButton(CopperGolemEntity copperGolem, BlockPos buttonPos) {
        BlockState buttonBlockState = this.getButtonBlockState(copperGolem, buttonPos);
        if (buttonBlockState == null || ((Boolean)buttonBlockState.m_61143_((Property)ButtonBlock.f_51045_)).booleanValue()) {
            return false;
        }
        ButtonBlock buttonBlock = (ButtonBlock)buttonBlockState.m_60734_();
        buttonBlock.m_51116_(buttonBlockState, copperGolem.m_9236_(), buttonPos);
        copperGolem.m_20193_().m_5594_(null, buttonPos, buttonBlock.m_5722_(true), SoundSource.BLOCKS, 0.3f, 0.6f);
        copperGolem.m_20193_().m_142346_((Entity)copperGolem, GameEvent.f_223702_, buttonPos);
        return true;
    }

    @Nullable
    private BlockState getButtonBlockState(CopperGolemEntity copperGolem, BlockPos buttonBlockPos) {
        ServerLevel serverWorld = (ServerLevel)copperGolem.m_20193_();
        BlockState blockState = serverWorld.m_8055_(buttonBlockPos);
        if (!(blockState.m_60734_() instanceof ButtonBlock)) {
            return null;
        }
        return blockState;
    }
}

