/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public class RascalFindInteractionTargetTask
extends Behavior<LivingEntity> {
    private final int maxSquaredDistance;
    private final Predicate<LivingEntity> predicate;
    private final Predicate<LivingEntity> shouldRunPredicate;

    public RascalFindInteractionTargetTask(int maxDistance, Predicate<LivingEntity> shouldRunPredicate, Predicate<LivingEntity> predicate) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT));
        this.maxSquaredDistance = maxDistance * maxDistance;
        this.predicate = predicate;
        this.shouldRunPredicate = shouldRunPredicate;
    }

    public RascalFindInteractionTargetTask(int maxDistance) {
        this(maxDistance, livingEntity -> true, livingEntity -> true);
    }

    public boolean m_6114_(ServerLevel world, LivingEntity entity) {
        return this.shouldRunPredicate.test(entity) && this.getVisibleMobs(entity).m_186130_(this::test);
    }

    public void m_6735_(ServerLevel world, LivingEntity entity, long time) {
        super.m_6735_(world, entity, time);
        Brain brain = entity.m_6274_();
        brain.m_21952_(MemoryModuleType.f_148205_).flatMap(livingTargetCache -> livingTargetCache.m_186116_(target -> target.m_20280_((Entity)entity) <= (double)this.maxSquaredDistance && target instanceof Player && !target.m_5833_() && !((Player)target).m_7500_())).ifPresent(target -> {
            brain.m_21879_(MemoryModuleType.f_26374_, target);
            brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
        });
    }

    private boolean test(LivingEntity entity) {
        return EntityType.f_20532_.equals(entity.m_6095_()) && this.predicate.test(entity);
    }

    private NearestVisibleLivingEntities getVisibleMobs(LivingEntity entity) {
        return (NearestVisibleLivingEntities)entity.m_6274_().m_21952_(MemoryModuleType.f_148205_).get();
    }
}

