/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public final class TuffGolemGoToHomePositionTask
extends Behavior<TuffGolemEntity> {
    private static final int GO_TO_SLEEP_POSITION_DURATION = 2400;

    public TuffGolemGoToHomePositionTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 2400);
    }

    protected boolean shouldRun(ServerLevel world, TuffGolemEntity tuffGolem) {
        return !tuffGolem.isInSleepingPose() && !tuffGolem.isAtHomePos() && !tuffGolem.isGlued() && !tuffGolem.m_21523_() && !tuffGolem.m_20159_() && tuffGolem.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void run(ServerLevel serverWorld, TuffGolemEntity tuffGolem, long l) {
        this.walkTowardsHomePos(tuffGolem);
    }

    protected boolean shouldKeepRunning(ServerLevel world, TuffGolemEntity tuffGolem, long time) {
        return !tuffGolem.isAtHome() && !tuffGolem.isGlued() && !tuffGolem.m_21523_() && !tuffGolem.m_20159_() && tuffGolem.m_6274_().m_21952_(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void keepRunning(ServerLevel world, TuffGolemEntity tuffGolem, long time) {
        if (tuffGolem.m_21573_().m_26571_()) {
            this.walkTowardsHomePos(tuffGolem);
        }
        if (!tuffGolem.isCloseToHomePos(2.0f) || Math.abs((int)tuffGolem.m_20186_() - (int)tuffGolem.getHomePos().m_7098_()) > 1) {
            return;
        }
        tuffGolem.m_20256_(new Vec3(tuffGolem.getHomePos().m_7096_() - tuffGolem.m_20185_(), tuffGolem.getHomePos().m_7098_() - tuffGolem.m_20186_(), tuffGolem.getHomePos().m_7094_() - tuffGolem.m_20189_()));
        tuffGolem.setSpawnYaw(tuffGolem.getHomeYaw());
    }

    protected void finishRunning(ServerLevel world, TuffGolemEntity tuffGolem, long time) {
        if (tuffGolem.isCloseToHomePos(1.5f)) {
            tuffGolem.m_146884_(tuffGolem.getHomePos());
        }
        MovementUtil.stopMovement((Mob)tuffGolem);
    }

    private void walkTowardsHomePos(TuffGolemEntity tuffGolem) {
        BehaviorUtils.m_22617_((LivingEntity)tuffGolem, (BlockPos)new BlockPos(tuffGolem.getHomePos()), (float)0.6f, (int)0);
    }
}

