/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.BlazeEntityAccess;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public final class WildfireSummonBlazeTask
extends Behavior<WildfireEntity> {
    private LivingEntity attackTarget;
    private int summonedBlazesCount;
    private static final int SUMMON_BLAZES_DURATION = 20;
    public static final int MIN_BLAZES_TO_BE_SUMMONED = 1;
    private static final int MAX_BLAZES_TO_BE_SUMMONED = 2;

    public WildfireSummonBlazeTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 20);
    }

    protected boolean shouldRun(ServerLevel world, WildfireEntity wildfire) {
        LivingEntity attackTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        if (attackTarget == null || !attackTarget.m_6084_() || attackTarget instanceof Player && (attackTarget.m_5833_() || ((Player)attackTarget).m_7500_()) || wildfire.getSummonedBlazesCount() == 2) {
            WildfireBrain.setSummonBlazeCooldown(wildfire);
            return false;
        }
        this.attackTarget = attackTarget;
        return true;
    }

    protected void run(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        wildfire.m_21573_().m_26573_();
        BehaviorUtils.m_22595_((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        wildfire.m_21563_().m_148051_((Entity)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        this.summonedBlazesCount = 0;
    }

    protected boolean shouldKeepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        return this.summonedBlazesCount == 0;
    }

    protected void keepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        BehaviorUtils.m_22595_((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        ServerLevel serverWorld = (ServerLevel)wildfire.m_9236_();
        int blazesToBeSummoned = Math.max(0, wildfire.m_217043_().m_216332_(1, 2) - wildfire.getSummonedBlazesCount());
        if (blazesToBeSummoned > 0) {
            wildfire.playSummonBlazeSound();
        }
        for (int i = 0; i < blazesToBeSummoned; ++i) {
            BlockPos blockPos = wildfire.m_20183_().m_7918_(-2 + wildfire.m_217043_().m_188503_(5), 1, -2 + wildfire.m_217043_().m_188503_(5));
            Blaze blazeEntity = (Blaze)EntityType.f_20551_.m_20615_((Level)serverWorld);
            blazeEntity.m_20035_(blockPos, 0.0f, 0.0f);
            blazeEntity.m_6710_(this.attackTarget);
            ((BlazeEntityAccess)blazeEntity).friendsandfoes_setWildfire(wildfire);
            blazeEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
            serverWorld.m_47205_((Entity)blazeEntity);
            ++this.summonedBlazesCount;
            wildfire.setSummonedBlazesCount(wildfire.getSummonedBlazesCount() + 1);
        }
    }

    protected void finishRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        WildfireBrain.setSummonBlazeCooldown(wildfire);
    }
}

