/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.init.registry.RegistryEntry;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistries;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistry;
import com.faboslav.friendsandfoes.common.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.levelgen.Heightmap;

public final class FriendsAndFoesEntityTypes {
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create(Registry.f_122826_, "friendsandfoes");
    public static boolean previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
    public static final RegistryEntry<EntityType<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistryEntry<EntityType<CrabEntity>> CRAB;
    public static final RegistryEntry<EntityType<GlareEntity>> GLARE;
    public static final RegistryEntry<EntityType<IceologerEntity>> ICEOLOGER;
    public static final RegistryEntry<EntityType<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistryEntry<EntityType<MaulerEntity>> MAULER;
    public static final RegistryEntry<EntityType<MoobloomEntity>> MOOBLOOM;
    public static final RegistryEntry<EntityType<RascalEntity>> RASCAL;
    public static final RegistryEntry<EntityType<TuffGolemEntity>> TUFF_GOLEM;
    public static final RegistryEntry<EntityType<WildfireEntity>> WILDFIRE;
    public static final RegistryEntry<EntityType<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void registerEntityAttributes(RegisterEntityAttributesEvent event) {
        event.register(COPPER_GOLEM.get(), CopperGolemEntity.createCopperGolemAttributes());
        event.register(CRAB.get(), CrabEntity.createCrabAttributes());
        event.register(GLARE.get(), GlareEntity.createGlareAttributes());
        event.register(ICEOLOGER.get(), IceologerEntity.createIceologerAttributes());
        event.register(MAULER.get(), MaulerEntity.createMaulerAttributes());
        event.register(MOOBLOOM.get(), MoobloomEntity.m_28307_());
        event.register(RASCAL.get(), RascalEntity.createRascalAttributes());
        event.register(TUFF_GOLEM.get(), TuffGolemEntity.createTuffGolemAttributes());
        event.register(WILDFIRE.get(), WildfireEntity.createWildfireAttributes());
        event.register(PLAYER_ILLUSION.get(), PlayerIllusionEntity.m_21552_());
    }

    public static void registerEntitySpawnRestrictions(RegisterEntitySpawnRestrictionsEvent event) {
        event.register(CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::canSpawn);
        event.register(GLARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        event.register(ICEOLOGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        event.register(MAULER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MaulerEntity::canSpawn);
        event.register(MOOBLOOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
        event.register(RASCAL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RascalEntity::canSpawn);
    }

    public static void addSpawnBiomeModifications(AddSpawnBiomeModificationsEvent event) {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableCrab && config.enableCrabSpawn) {
            event.add(FriendsAndFoesTags.HAS_CRAB, MobCategory.CREATURE, CRAB.get(), config.crabSpawnWeight, config.crabSpawnMinGroupSize, config.crabSpawnMaxGroupSize);
        }
        if (config.enableGlare && config.enableGlareSpawn) {
            event.add(FriendsAndFoesTags.HAS_GLARE, CustomSpawnGroup.getGlaresCategory(), GLARE.get(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            event.add(FriendsAndFoesTags.HAS_BADLANDS_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_DESERT_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_SAVANNA_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            event.add(FriendsAndFoesTags.HAS_MOOBLOOMS, MobCategory.CREATURE, MOOBLOOM.get(), config.moobloomSpawnWeight, config.moobloomSpawnMinGroupSize, config.moobloomSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            event.add(FriendsAndFoesTags.HAS_RASCAL, CustomSpawnGroup.getRascalsCategory(), RASCAL.get(), 4, 1, 1);
        }
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        SharedConstants.f_136182_ = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> EntityType.Builder.m_20704_(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 1.375f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("copper_golem")));
        CRAB = ENTITY_TYPES.register("crab", () -> EntityType.Builder.m_20704_(CrabEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.875f, 0.5625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("crab")));
        GLARE = ENTITY_TYPES.register("glare", () -> EntityType.Builder.m_20704_(GlareEntity::new, (MobCategory)CustomSpawnGroup.getGlaresCategory()).m_20699_(0.875f, 1.1875f).m_20702_(8).m_20717_(2).m_20712_(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> EntityType.Builder.m_20704_(IceologerEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> EntityType.Builder.m_20704_(IceologerIceChunkEntity::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(2.5f, 1.0f).m_20702_(6).m_20712_(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> EntityType.Builder.m_20704_(MaulerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5625f, 0.5625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> EntityType.Builder.m_20704_(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("moobloom")));
        RASCAL = ENTITY_TYPES.register("rascal", () -> EntityType.Builder.m_20704_(RascalEntity::new, (MobCategory)CustomSpawnGroup.getRascalsCategory()).m_20699_(0.9f, 1.25f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("rascal")));
        TUFF_GOLEM = ENTITY_TYPES.register("tuff_golem", () -> EntityType.Builder.m_20704_(TuffGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 1.0625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("tuff_golem")));
        WILDFIRE = ENTITY_TYPES.register("wildfire", () -> EntityType.Builder.m_20704_(WildfireEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.12f, 3.0f).m_20702_(10).m_20719_().m_20712_(FriendsAndFoes.makeStringID("wildfire")));
        PLAYER_ILLUSION = ENTITY_TYPES.register("player_illusion", () -> EntityType.Builder.m_20704_(PlayerIllusionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.7f, 1.875f).m_20702_(10).m_20719_().m_20712_(FriendsAndFoes.makeStringID("player_illusion")));
        SharedConstants.f_136182_ = previousUseChoiceTypeRegistrations;
    }
}

