/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.util;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.platform.ModVersion;
import com.faboslav.friendsandfoes.common.platform.Platform;
import com.faboslav.friendsandfoes.common.platform.ProjectUrlProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Gson gson = new Gson();

    public static void checkForNewUpdatesInGame(LocalPlayer clientPlayerEntity) {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            String updateMessageString = MessageFormat.format("Friend&Foes update is available! You are using {0} version, but the latest version is {1}. You can download it at ", modVersion, latestVersion.toString());
            MutableComponent updateMessage = Component.m_237113_((String)updateMessageString);
            MutableComponent curseforgeLink = Component.m_237113_((String)"CurseForge").m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ProjectUrlProvider.getCurseForgeProjectLink())).m_131162_(Boolean.valueOf(true)));
            MutableComponent updateMessageSecondPart = Component.m_237113_((String)" or ");
            MutableComponent modrinthLink = Component.m_237113_((String)"Modrinth").m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ProjectUrlProvider.getModrinthProjectLink())).m_131162_(Boolean.valueOf(true)));
            MutableComponent updateMessageThirdPart = Component.m_237113_((String)".");
            updateMessage.m_7220_((Component)curseforgeLink).m_7220_((Component)updateMessageSecondPart).m_7220_((Component)modrinthLink).m_7220_((Component)updateMessageThirdPart);
            clientPlayerEntity.m_5661_((Component)updateMessage, false);
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    public static void checkForNewUpdates() {
        CompletableFuture.runAsync(() -> {
            if (!FriendsAndFoes.getConfig().checkForNewUpdates) {
                return;
            }
            ModuleDescriptor.Version latestVersion = UpdateChecker.getLatestVersion();
            if (latestVersion == null) {
                return;
            }
            String modVersion = ModVersion.getModVersion();
            if (modVersion == null) {
                return;
            }
            if (latestVersion.compareTo(ModuleDescriptor.Version.parse(modVersion)) <= 0) {
                return;
            }
            FriendsAndFoes.getLogger().info("[Friends&Foes] An update is available! You are using {} version, but the latest version is {}.", (Object)modVersion, (Object)latestVersion.toString());
        });
    }

    @Nullable
    public static ModuleDescriptor.Version getLatestVersion() {
        HttpResponse<String> response;
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.modrinth.com/v2/project/" + Platform.getProjectSlug() + "/version")).build();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
        if (response.statusCode() != 200) {
            return null;
        }
        HashMap<String, String> releases = new HashMap<String, String>();
        try {
            JsonArray jsonArray = (JsonArray)gson.fromJson(response.body(), JsonArray.class);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject versionObject = jsonArray.get(i).getAsJsonObject();
                String versionNumber = versionObject.get("version_number").getAsString();
                String modVersion = versionNumber.substring(versionNumber.lastIndexOf(45) + 1);
                JsonArray gameVersions = versionObject.getAsJsonArray("game_versions");
                for (JsonElement gameVersion : gameVersions) {
                    if (releases.containsKey(gameVersion.getAsString())) continue;
                    releases.put(gameVersion.getAsString(), modVersion);
                }
            }
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        String gameVersion = SharedConstants.m_183709_().getName();
        if (!releases.containsKey(gameVersion)) {
            return null;
        }
        return ModuleDescriptor.Version.parse((String)releases.get(gameVersion));
    }
}

