/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.ModResourcesFinder;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.client.BlockColorHandler;
import dev.gigaherz.jsonthings.things.client.ItemColorHandler;
import dev.gigaherz.jsonthings.things.parsers.ArmorMaterialParser;
import dev.gigaherz.jsonthings.things.parsers.BlockMaterialParser;
import dev.gigaherz.jsonthings.things.parsers.BlockParser;
import dev.gigaherz.jsonthings.things.parsers.CreativeModeTabParser;
import dev.gigaherz.jsonthings.things.parsers.EnchantmentParser;
import dev.gigaherz.jsonthings.things.parsers.FluidParser;
import dev.gigaherz.jsonthings.things.parsers.FluidTypeParser;
import dev.gigaherz.jsonthings.things.parsers.FoodParser;
import dev.gigaherz.jsonthings.things.parsers.ItemParser;
import dev.gigaherz.jsonthings.things.parsers.MobEffectInstanceParser;
import dev.gigaherz.jsonthings.things.parsers.ShapeParser;
import dev.gigaherz.jsonthings.things.parsers.ThingResourceManager;
import dev.gigaherz.jsonthings.things.parsers.TierParser;
import dev.gigaherz.jsonthings.things.scripting.ScriptParser;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.resource.ResourcePackLoader;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="jsonthings", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="jsonthings")
public class JsonThings {
    public static final String MODID = "jsonthings";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static BlockParser blockParser;
    public static ItemParser itemParser;
    public static FluidParser fluidParser;
    public static EnchantmentParser enchantmentParser;
    public static FoodParser foodParser;
    public static ShapeParser shapeParser;
    public static TierParser tierParser;
    public static FluidTypeParser fluidTypeParser;
    public static BlockMaterialParser blockMaterialParser;
    public static ArmorMaterialParser armorMaterialParser;
    public static CreativeModeTabParser creativeModeTabParser;
    public static MobEffectInstanceParser mobEffectInstanceParser;
    private static CompletableFuture<ThingResourceManager> loaderFuture;

    public JsonThings() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ThingResourceManager manager = ThingResourceManager.instance();
        if (ModList.get().isLoaded("rhino")) {
            ScriptParser.enable(manager);
        }
        blockParser = manager.registerParser(new BlockParser(bus));
        itemParser = manager.registerParser(new ItemParser(bus));
        fluidParser = manager.registerParser(new FluidParser(bus));
        enchantmentParser = manager.registerParser(new EnchantmentParser(bus));
        foodParser = manager.registerParser(new FoodParser());
        shapeParser = manager.registerParser(new ShapeParser());
        tierParser = manager.registerParser(new TierParser());
        fluidTypeParser = manager.registerParser(new FluidTypeParser(bus));
        blockMaterialParser = manager.registerParser(new BlockMaterialParser());
        armorMaterialParser = manager.registerParser(new ArmorMaterialParser());
        creativeModeTabParser = manager.registerParser(new CreativeModeTabParser());
        mobEffectInstanceParser = manager.registerParser(new MobEffectInstanceParser());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> {
            ThingResourceManager instance = ThingResourceManager.instance();
            ResourcePackLoader.loadResourcePacks((PackRepository)instance.getRepository(), ModResourcesFinder::buildPackFinder);
            loaderFuture = instance.beginLoading();
        });
    }

    @SubscribeEvent
    public static void packFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(ThingResourceManager.instance().getWrappedPackFinder());
        }
    }

    @SubscribeEvent
    public static void finishLoading(NewRegistryEvent event) {
        ThingResourceManager.instance().waitForLoading(loaderFuture);
        loaderFuture = null;
    }

    static {
        ThingRegistries.staticInit();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="jsonthings", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientHandlers {
        public static void addClientPackFinder() {
            Minecraft.m_91087_().m_91099_().addPackFinder(ThingResourceManager.instance().getWrappedPackFinder());
        }

        @SubscribeEvent
        public static void constructMod(FMLConstructModEvent event) {
            event.enqueueWork(() -> {
                ClientHandlers.addClientPackFinder();
                BlockColorHandler.init();
                ItemColorHandler.init();
            });
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, returnTo) -> {
                ThingResourceManager thingPackManager = ThingResourceManager.instance();
                return new PackSelectionScreen(returnTo, thingPackManager.getRepository(), rpl -> thingPackManager.onConfigScreenSave(), thingPackManager.getThingPacksLocation().toFile(), (Component)Component.m_237113_((String)"Thing Packs"));
            }));
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ResourceLocation solid = new ResourceLocation("solid");
            blockParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                ResourceLocation layer = thing.getDefaultRenderLayer();
                if (!layer.equals((Object)solid)) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((IFlexBlock)thing.get()).self(), (RenderType)NamedRenderTypeManager.get((ResourceLocation)layer).block());
                }
            });
            fluidParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                ResourceLocation layer = thing.getDefaultRenderLayer();
                for (Fluid fluid : thing.getAllSiblings()) {
                    if (layer.equals((Object)solid)) continue;
                    ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)NamedRenderTypeManager.get((ResourceLocation)layer).block());
                }
            });
        }

        @SubscribeEvent
        public static void itemColorHandlers(RegisterColorHandlersEvent.Block event) {
            blockParser.getBuilders().forEach(thing -> {
                String handlerName = thing.getColorHandler();
                if (handlerName != null) {
                    BlockColor bc = BlockColorHandler.get(handlerName);
                    event.register(bc, new Block[]{((IFlexBlock)thing.get()).self()});
                }
            });
        }

        @SubscribeEvent
        public static void itemColorHandlers(RegisterColorHandlersEvent.Item event) {
            itemParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                String handlerName = thing.getColorHandler();
                if (handlerName != null) {
                    Function<BlockColors, ItemColor> handler = ItemColorHandler.get(handlerName);
                    ItemColor ic = handler.apply(event.getBlockColors());
                    event.register(ic, new ItemLike[]{((IFlexItem)thing.get()).self()});
                }
            });
        }
    }
}

