/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;

public class QueueableExecutor
implements Executor {
    private final Thread thread = Thread.currentThread();
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private final Semaphore sem = new Semaphore(1);

    public boolean isSameThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (!this.isSameThread()) {
            this.queue.add(command);
            this.sem.release();
        } else {
            command.run();
        }
    }

    public void runQueue() {
        if (!this.isSameThread()) {
            throw new IllegalStateException("This method must be called in the main thread.");
        }
        while (this.queue.size() > 0) {
            Runnable run = this.queue.poll();
            if (run == null) continue;
            run.run();
        }
    }

    public void finish() {
        this.sem.release();
    }

    public void waitForTasks() throws InterruptedException {
        this.sem.acquire();
    }
}

