/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.IBlockFactory;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class BlockBuilder
extends BaseBuilder<IFlexBlock, BlockBuilder> {
    private List<Property<?>> properties;
    private Map<String, Property<?>> propertiesByName;
    private Map<String, String> propertyDefaultValues;
    private Map<Property<?>, Comparable<?>> propertyDefaultValuesMap;
    private FlexBlockType<?> blockType;
    private ResourceLocation blockMaterial;
    private MaterialColor blockMaterialColor;
    private ItemBuilder itemBuilder;
    private DynamicShape generalShape;
    private DynamicShape collisionShape;
    private DynamicShape raytraceShape;
    private DynamicShape renderShape;
    private Boolean seeThrough;
    private String colorHandler;
    private Boolean requiresToolForDrops;
    private Boolean isAir;
    private Boolean hasCollision;
    private Boolean randomTicks;
    private Integer lightEmission;
    private Float explosionResistance;
    private Float destroyTime;
    private Float friction;
    private Float speedFactor;
    private Float jumpFactor;
    private ResourceLocation soundType;
    private IBlockFactory<? extends Block> factory;

    public static BlockBuilder begin(ThingParser<BlockBuilder> ownerParser, ResourceLocation registryName) {
        return new BlockBuilder(ownerParser, registryName);
    }

    private BlockBuilder(ThingParser<BlockBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Block";
    }

    public void setBlockType(ResourceLocation typeName) {
        FlexBlockType blockType = (FlexBlockType)ThingRegistries.BLOCK_TYPES.m_7745_(typeName);
        if (blockType == null) {
            throw new IllegalStateException("No known block type with name " + typeName);
        }
        this.blockType = blockType;
    }

    public void setBlockType(FlexBlockType<?> type) {
        if (ThingRegistries.BLOCK_TYPES.m_7981_(type) == null) {
            throw new IllegalStateException("Block type not registered!");
        }
        this.blockType = type;
    }

    @Nullable
    public FlexBlockType<?> getBlockTypeRaw() {
        return this.getValue(this.blockType, BlockBuilder::getBlockTypeRaw);
    }

    public FlexBlockType<?> getBlockType() {
        return Utils.orElseGet(this.getBlockTypeRaw(), () -> FlexBlockType.PLAIN);
    }

    public boolean hasBlockType() {
        return this.getBlockTypeRaw() != null;
    }

    public void setItem(ItemBuilder itemBuilder) {
        this.itemBuilder = itemBuilder;
    }

    public void setProperties(Map<String, Property<?>> properties) {
        this.properties = properties.values().stream().toList();
        this.propertiesByName = properties;
    }

    @Nullable
    public List<Property<?>> getPropertiesRaw() {
        return this.getValue(this.properties, BlockBuilder::getPropertiesRaw);
    }

    public List<Property<?>> getProperties() {
        return Utils.orElseGet(this.getPropertiesRaw(), List::of);
    }

    public void setPropertyDefaultValue(String name, String value) {
        if (this.propertyDefaultValues == null) {
            this.propertyDefaultValues = new HashMap<String, String>();
        }
        this.propertyDefaultValues.put(name, value);
    }

    @Nullable
    public Map<String, String> getPropertyDefaultValuesRaw() {
        return this.getValue(this.propertyDefaultValues, BlockBuilder::getPropertyDefaultValuesRaw);
    }

    public Map<Property<?>, Comparable<?>> getPropertyDefaultValues() {
        if (this.propertyDefaultValuesMap == null) {
            Map<String, String> raw = this.getPropertyDefaultValuesRaw();
            this.propertyDefaultValuesMap = raw == null ? Map.of() : raw.entrySet().stream().map(e -> {
                Property<?> key = this.propertiesByName.get(e.getKey());
                Object value = Utils.getPropertyValue(key, (String)e.getValue());
                return Pair.of(key, value);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }
        return this.propertyDefaultValuesMap;
    }

    public void setMaterial(ResourceLocation material) {
        this.blockMaterial = material;
    }

    @Nullable
    public ResourceLocation getMaterialRaw() {
        return this.getValue(this.blockMaterial, BlockBuilder::getMaterialRaw);
    }

    public Material getMaterial() {
        ResourceLocation matName = this.getMaterialRaw();
        Material mat = matName != null ? (Material)ThingRegistries.BLOCK_MATERIALS.m_7745_(matName) : null;
        return Utils.orElse(mat, this.getBlockType().getDefaultMaterial());
    }

    public void setMaterialColor(MaterialColor mapColor) {
        this.blockMaterialColor = mapColor;
    }

    @Nullable
    public MaterialColor getMaterialColor() {
        return this.getValue(this.blockMaterialColor, BlockBuilder::getMaterialColor);
    }

    public void setGeneralShape(DynamicShape shape) {
        this.generalShape = shape;
    }

    @Nullable
    public DynamicShape getGeneralShape() {
        return this.getValue(this.generalShape, BlockBuilder::getGeneralShape);
    }

    public void setCollisionShape(DynamicShape shape) {
        this.collisionShape = shape;
    }

    @Nullable
    public DynamicShape getCollisionShape() {
        return this.getValue(this.collisionShape, BlockBuilder::getCollisionShape);
    }

    public void setRaytraceShape(DynamicShape shape) {
        this.raytraceShape = shape;
    }

    @Nullable
    public DynamicShape getRaytraceShape() {
        return this.getValue(this.raytraceShape, BlockBuilder::getRaytraceShape);
    }

    public void setRenderShape(DynamicShape shape) {
        this.renderShape = shape;
    }

    @Nullable
    public DynamicShape getRenderShape() {
        return this.getValue(this.renderShape, BlockBuilder::getRenderShape);
    }

    public ResourceLocation getDefaultRenderLayer() {
        return new ResourceLocation(this.getBlockType().getDefaultLayer());
    }

    public void setColorHandler(String colorHandler) {
        this.colorHandler = colorHandler;
    }

    @Nullable
    public String getColorHandler() {
        return this.getValue(this.colorHandler, BlockBuilder::getColorHandler);
    }

    public void setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
    }

    @Nullable
    public Boolean isSeeThrough() {
        return this.getValue(this.seeThrough, BlockBuilder::isSeeThrough);
    }

    public void setRequiresToolForDrops(boolean requiresToolForDrops) {
        this.requiresToolForDrops = requiresToolForDrops;
    }

    @Nullable
    public Boolean requiresToolForDrops() {
        return this.getValue(this.requiresToolForDrops, BlockBuilder::requiresToolForDrops);
    }

    public void setIsAir(boolean isAir) {
        this.isAir = isAir;
    }

    @Nullable
    public Boolean getIsAir() {
        return this.getValue(this.isAir, BlockBuilder::getIsAir);
    }

    public void setHasCollision(boolean hasCollision) {
        this.hasCollision = hasCollision;
    }

    @Nullable
    public Boolean getHasCollision() {
        return this.getValue(this.hasCollision, BlockBuilder::getHasCollision);
    }

    public void setTicksRandom(boolean randomTicks) {
        this.randomTicks = randomTicks;
    }

    @Nullable
    public Boolean getTicksRandom() {
        return this.getValue(this.randomTicks, BlockBuilder::getTicksRandom);
    }

    public void setLightEmission(int lightEmission) {
        this.lightEmission = lightEmission;
    }

    @Nullable
    public Integer getLightEmission() {
        return this.getValue(this.lightEmission, BlockBuilder::getLightEmission);
    }

    public void setExplosionResistance(float explosionResistance) {
        this.explosionResistance = Float.valueOf(explosionResistance);
    }

    @Nullable
    public Float getExplosionResistance() {
        return this.getValue(this.explosionResistance, BlockBuilder::getExplosionResistance);
    }

    public void setDestroyTime(float destroyTime) {
        this.destroyTime = Float.valueOf(destroyTime);
    }

    @Nullable
    public Float getDestroyTime() {
        return this.getValue(this.destroyTime, BlockBuilder::getDestroyTime);
    }

    public void setFriction(float friction) {
        this.friction = Float.valueOf(friction);
    }

    @Nullable
    public Float getFriction() {
        return this.getValue(this.friction, BlockBuilder::getFriction);
    }

    public void setSpeedFactor(float speedFactor) {
        this.speedFactor = Float.valueOf(speedFactor);
    }

    @Nullable
    public Float getSpeedFactor() {
        return this.getValue(this.speedFactor, BlockBuilder::getSpeedFactor);
    }

    public void setJumpFactor(float jumpFactor) {
        this.jumpFactor = Float.valueOf(jumpFactor);
    }

    @Nullable
    public Float getJumpFactor() {
        return this.getValue(this.jumpFactor, BlockBuilder::getJumpFactor);
    }

    public void setSoundType(ResourceLocation loc) {
        this.soundType = loc;
    }

    @Nullable
    public ResourceLocation getSoundType() {
        return this.getValue(this.soundType, BlockBuilder::getSoundType);
    }

    @Override
    protected IFlexBlock buildInternal() {
        Material material = this.getMaterial();
        MaterialColor blockMaterialColor = this.getMaterialColor();
        BlockBehaviour.Properties props = blockMaterialColor != null ? BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)blockMaterialColor) : BlockBehaviour.Properties.m_60939_((Material)material);
        FlexBlockType<?> blockType = this.getBlockType();
        if (Utils.orElse(this.isSeeThrough(), blockType.isDefaultSeeThrough()).booleanValue()) {
            props.m_60955_();
        }
        if (Utils.orElse(this.requiresToolForDrops(), false).booleanValue()) {
            props.m_60999_();
        }
        if (Utils.orElse(this.getIsAir(), false).booleanValue()) {
            props.m_60996_();
        }
        if (!Utils.orElse(this.getHasCollision(), true).booleanValue()) {
            props.m_60910_();
        }
        if (Utils.orElse(this.getTicksRandom(), false).booleanValue()) {
            props.m_60977_();
        }
        if (Utils.orElse(this.getLightEmission(), 0) > 0) {
            props.m_60953_(state -> this.getLightEmission());
        }
        if (Utils.orElse(this.getExplosionResistance(), Float.valueOf(0.0f)).floatValue() > 0.0f) {
            props.m_155956_(this.getExplosionResistance().floatValue());
        }
        if (Utils.orElse(this.getDestroyTime(), Float.valueOf(0.0f)).floatValue() > 0.0f) {
            props.m_155954_(this.getDestroyTime().floatValue());
        }
        if (Utils.orElse(this.getFriction(), Float.valueOf(0.6f)).floatValue() != 0.6f) {
            props.m_60911_(this.getFriction().floatValue());
        }
        if (Utils.orElse(this.getSpeedFactor(), Float.valueOf(1.0f)).floatValue() != 1.0f) {
            props.m_60956_(this.getSpeedFactor().floatValue());
        }
        if (Utils.orElse(this.getJumpFactor(), Float.valueOf(1.0f)).floatValue() != 1.0f) {
            props.m_60967_(this.getSpeedFactor().floatValue());
        }
        if (this.getSoundType() != null) {
            props.m_60918_(Utils.getOrCrash(ThingRegistries.SOUND_TYPES, this.getSoundType()));
        }
        List<Property<?>> stockProperties = blockType.getStockProperties();
        List<Property<?>> properties = this.getProperties();
        List<Property> badProperties = properties.stream().filter(prop -> {
            for (Property p : stockProperties) {
                if (p == prop || !p.m_61708_().equals(prop.m_61708_())) continue;
                return true;
            }
            return false;
        }).toList();
        if (badProperties.size() > 0) {
            throw new IllegalStateException("The block of type " + blockType + " cannot define non-duplicate properties with clashing names: " + badProperties.stream().map(Property::m_61708_).collect(Collectors.joining(" ")));
        }
        IFlexBlock flexBlock = (IFlexBlock)this.factory.construct(props, this);
        flexBlock.setGeneralShape(this.getGeneralShape());
        flexBlock.setCollisionShape(this.getCollisionShape());
        flexBlock.setRaytraceShape(this.getRaytraceShape());
        flexBlock.setRenderShape(this.getRenderShape());
        this.constructEventHandlers(flexBlock);
        return flexBlock;
    }

    public Map<String, Property<?>> getPropertiesByName() {
        return Collections.unmodifiableMap(this.propertiesByName);
    }

    @Nullable
    public ItemBuilder getItemBuilder() {
        return this.itemBuilder;
    }

    public void setFactory(IBlockFactory<?> factory) {
        this.factory = factory;
    }
}

