/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.MobEffectInstanceBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;

public class FoodBuilder
extends BaseBuilder<FoodProperties, FoodBuilder> {
    private final List<Pair<MobEffectInstanceBuilder, Float>> effects = new ArrayList<Pair<MobEffectInstanceBuilder, Float>>();
    private int nutrition;
    private float saturation;
    private boolean isMeat;
    private boolean alwaysEat;
    private boolean fast;

    public static FoodBuilder begin(ThingParser<FoodBuilder> ownerParser, ResourceLocation registryName) {
        return new FoodBuilder(ownerParser, registryName);
    }

    private FoodBuilder(ThingParser<FoodBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Food Definition";
    }

    public void setNutrition(int num) {
        this.nutrition = num;
    }

    public void setSaturation(float num) {
        this.saturation = num;
    }

    public void setIsMeat(boolean isMeat) {
        this.isMeat = isMeat;
    }

    public void setAlwaysEat(boolean alwaysEat) {
        this.alwaysEat = alwaysEat;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    public void effect(MobEffectInstanceBuilder effect, float probability) {
        this.effects.add((Pair<MobEffectInstanceBuilder, Float>)Pair.of((Object)effect, (Object)Float.valueOf(probability)));
    }

    @Override
    protected FoodProperties buildInternal() {
        FoodProperties.Builder foodBuilder = new FoodProperties.Builder();
        foodBuilder.m_38760_(this.nutrition);
        foodBuilder.m_38758_(this.saturation);
        if (this.isMeat) {
            foodBuilder.m_38757_();
        }
        if (this.fast) {
            foodBuilder.m_38766_();
        }
        if (this.alwaysEat) {
            foodBuilder.m_38765_();
        }
        this.effects.forEach(pair -> foodBuilder.effect(((MobEffectInstanceBuilder)pair.getFirst())::get, ((Float)pair.getSecond()).floatValue()));
        return foodBuilder.m_38767_();
    }
}

