/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.CreativeModeTabBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.IItemFactory;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemBuilder
extends BaseBuilder<IFlexItem, ItemBuilder> {
    private final Map<EquipmentSlot, Multimap<ResourceLocation, AttributeModifier>> attributeModifiers = Maps.newHashMap();
    private FlexItemType<?> itemType;
    private Integer maxStackSize = null;
    private Integer maxDamage = null;
    private final List<Pair<StackContext, String[]>> creativeMenuStacks = Lists.newArrayList();
    private NonNullSupplier<FoodProperties> foodDefinition = null;
    public Integer useTime = null;
    public UseAnim useAnim = null;
    public UseFinishMode useFinishMode = null;
    private ResourceLocation containerItem = null;
    private String colorHandler = null;
    private String[] toolActions;
    private List<MutableComponent> lore;
    private Integer burnDuration;
    private IItemFactory<? extends Item> factory;

    public static ItemBuilder begin(ThingParser<ItemBuilder> ownerParser, ResourceLocation registryName) {
        return new ItemBuilder(ownerParser, registryName);
    }

    private ItemBuilder(ThingParser<ItemBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Item";
    }

    public void setType(String typeName) {
        if (this.itemType != null) {
            throw new RuntimeException("Item type already set.");
        }
        FlexItemType itemType = (FlexItemType)ThingRegistries.ITEM_TYPES.m_7745_(new ResourceLocation(typeName));
        if (itemType == null) {
            throw new IllegalStateException("No known block type with name " + typeName);
        }
        this.itemType = itemType;
    }

    public void setType(FlexItemType<?> type) {
        if (ThingRegistries.ITEM_TYPES.m_7981_(type) == null) {
            throw new IllegalStateException("Item type not registered!");
        }
        this.itemType = type;
    }

    public void setMaxStackSize(int maxStackSize) {
        if (this.maxStackSize != null) {
            throw new RuntimeException("Max stack size already set.");
        }
        this.maxStackSize = maxStackSize;
    }

    public void withCreativeMenuStack(StackContext stackContext, String[] tabs) {
        this.creativeMenuStacks.add((Pair<StackContext, String[]>)Pair.of((Object)stackContext, (Object)tabs));
    }

    public void withAttributeModifier(EquipmentSlot slot, ResourceLocation attribute, @Nullable UUID uuid, String name, double amount, int op) {
        AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)op);
        AttributeModifier mod = uuid != null ? new AttributeModifier(uuid, name, amount, operation) : new AttributeModifier(name, amount, operation);
        this.attributeModifiers.computeIfAbsent(slot, _slot -> ArrayListMultimap.create()).put((Object)attribute, (Object)mod);
    }

    public void setMaxDamage(int maxDamage) {
        if (this.maxDamage != null) {
            throw new RuntimeException("Damageable already set.");
        }
        this.maxDamage = maxDamage;
    }

    public void setFood(ResourceLocation foodName) {
        if (this.foodDefinition != null) {
            throw new RuntimeException("Food info already set.");
        }
        this.foodDefinition = () -> ThingRegistries.FOODS.m_6612_(foodName).orElseGet(() -> (FoodProperties)((FoodBuilder)JsonThings.foodParser.getOrCrash(foodName)).get());
    }

    public void setFood(FoodProperties food) {
        if (this.foodDefinition != null) {
            throw new RuntimeException("Food info already set.");
        }
        this.foodDefinition = () -> food;
    }

    public void setUseTime(int useTime) {
        this.useTime = useTime;
    }

    public void setUseAnim(UseAnim useAnim) {
        this.useAnim = useAnim;
    }

    public void setUseFinishMode(UseFinishMode finishMode) {
        this.useFinishMode = finishMode;
    }

    @Deprecated
    public void makeContainer(String emptyItem) {
        if (emptyItem.contains(":")) {
            this.setContainerItem(new ResourceLocation(emptyItem));
        } else {
            this.setContainerItem(new ResourceLocation(this.getRegistryName().m_135827_(), emptyItem));
        }
    }

    public void setContainerItem(ResourceLocation resourceLocation) {
        if (this.containerItem != null) {
            throw new RuntimeException("Container Item already set.");
        }
        this.containerItem = resourceLocation;
    }

    public void setToolActions(String[] stringValues) {
        this.toolActions = stringValues;
    }

    public void setColorHandler(String colorHandler) {
        this.colorHandler = colorHandler;
    }

    public void setLore(List<MutableComponent> lore) {
        this.lore = lore;
    }

    public void setBurnDuration(int burnTime) {
        this.burnDuration = burnTime;
    }

    @Override
    protected IFlexItem buildInternal() {
        NonNullSupplier<FoodProperties> foodDefinition;
        ResourceLocation ci;
        Integer md;
        Item.Properties properties = new Item.Properties();
        Integer ms = this.getMaxStackSize();
        if (ms != null) {
            properties = properties.m_41487_(ms.intValue());
        }
        if ((md = this.getMaxDamage()) != null) {
            properties = properties.m_41503_(md.intValue());
        }
        if ((ci = this.getContainerItem()) != null) {
            properties = properties.m_41495_(Utils.getItemOrCrash(ci));
        }
        if ((foodDefinition = this.getFoodDefinition()) != null) {
            properties = properties.m_41489_((FoodProperties)foodDefinition.get());
        }
        IFlexItem flexItem = (IFlexItem)this.factory.construct(properties, this);
        List<Pair<StackContext, String[]>> stacks = this.getCreativeMenuStacks();
        if (stacks.size() > 0) {
            for (Pair<StackContext, String[]> tabEntries : stacks) {
                StackContext ctx = (StackContext)tabEntries.getFirst();
                String[] tabs = (String[])tabEntries.getSecond();
                Set<CreativeModeTab> tabsIterable = Arrays.stream(tabs).map(this::findCreativeTab).filter(Objects::nonNull).collect(Collectors.toSet());
                flexItem.addCreativeStack(ctx, tabsIterable);
            }
        }
        this.constructEventHandlers(flexItem);
        return flexItem;
    }

    @Nullable
    private CreativeModeTab findCreativeTab(String label) {
        ResourceLocation rl = new ResourceLocation(label);
        for (CreativeModeTabBuilder builder : JsonThings.creativeModeTabParser.getBuilders()) {
            if (!builder.getRegistryName().equals((Object)rl)) continue;
            return (CreativeModeTab)builder.get();
        }
        for (CreativeModeTab tab : CreativeModeTab.f_40748_) {
            if (!tab.m_40783_().equals(label)) continue;
            return tab;
        }
        return null;
    }

    public List<Pair<StackContext, String[]>> getCreativeMenuStacks() {
        if (this.creativeMenuStacks.size() > 0) {
            return this.creativeMenuStacks;
        }
        if (this.getParent() != null) {
            return ((ItemBuilder)this.getParent()).getCreativeMenuStacks();
        }
        return this.creativeMenuStacks;
    }

    @Nullable
    public Integer getMaxDamage() {
        return this.getValue(this.maxDamage, ItemBuilder::getMaxDamage);
    }

    @Nullable
    public Integer getMaxStackSize() {
        return this.getValue(this.maxStackSize, ItemBuilder::getMaxStackSize);
    }

    @Nullable
    public ResourceLocation getContainerItem() {
        return this.getValue(this.containerItem, ItemBuilder::getContainerItem);
    }

    @Nullable
    public NonNullSupplier<FoodProperties> getFoodDefinition() {
        return this.getValue(this.foodDefinition, ItemBuilder::getFoodDefinition);
    }

    @Nullable
    public FlexItemType<?> getTypeRaw() {
        return this.getValue(this.itemType, ItemBuilder::getTypeRaw);
    }

    public FlexItemType<?> getType() {
        return Utils.orElse(this.getTypeRaw(), FlexItemType.PLAIN);
    }

    public boolean hasType() {
        return this.getValueOrElse(this.itemType != null, ItemBuilder::hasType, false);
    }

    @Nullable
    public String getColorHandler() {
        return this.getValue(this.colorHandler, ItemBuilder::getColorHandler);
    }

    public void setFactory(IItemFactory<?> factory) {
        this.factory = factory;
    }

    @Nullable
    public UseAnim getUseAnim() {
        return this.getValue(this.useAnim, ItemBuilder::getUseAnim);
    }

    @Nullable
    public Integer getUseTime() {
        return this.getValue(this.useTime, ItemBuilder::getUseTime);
    }

    @Nullable
    public UseFinishMode getUseFinishMode() {
        return this.getValue(this.useFinishMode, ItemBuilder::getUseFinishMode);
    }

    @Nullable
    public List<MutableComponent> getLore() {
        return this.getValueOrElseGet(this.lore, ItemBuilder::getLore, List::of);
    }

    @Nullable
    public Integer getBurnDuration() {
        return this.getValue(this.burnDuration, ItemBuilder::getBurnDuration);
    }

    public Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getAttributeModifiers() {
        Map<EquipmentSlot, Multimap<ResourceLocation, AttributeModifier>> mods = this.getAttributeModifiersRaw();
        if (mods == null) {
            return Map.of();
        }
        HashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> modifiers = new HashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
        for (Map.Entry<EquipmentSlot, Multimap<ResourceLocation, AttributeModifier>> kv : mods.entrySet()) {
            Multimap map = modifiers.computeIfAbsent(kv.getKey(), slot -> ArrayListMultimap.create());
            for (Map.Entry kv1 : kv.getValue().entries()) {
                Attribute attr = (Attribute)Utils.getOrCrash(ForgeRegistries.ATTRIBUTES, (ResourceLocation)kv1.getKey());
                map.put((Object)attr, (Object)((AttributeModifier)kv1.getValue()));
            }
        }
        return modifiers;
    }

    @Nullable
    private Map<EquipmentSlot, Multimap<ResourceLocation, AttributeModifier>> getAttributeModifiersRaw() {
        return this.getValue(this.attributeModifiers, ItemBuilder::getAttributeModifiersRaw);
    }

    @Nullable
    public String[] getToolActionsRaw() {
        return this.getValue(this.toolActions, ItemBuilder::getToolActionsRaw);
    }

    @Nullable
    public Set<ToolAction> getToolActions() {
        String[] raw = this.getToolActionsRaw();
        if (raw == null) {
            return null;
        }
        return Arrays.stream(raw).map(ToolAction::get).collect(Collectors.toSet());
    }
}

