/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.events;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.events.ContextValue;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FlexEventContext {
    public static final ContextValue<ItemStack> STACK = ContextValue.create("stack", ItemStack.class);
    public static final ContextValue<LivingEntity> USER = ContextValue.create("user", LivingEntity.class);
    public static final ContextValue<Level> WORLD = ContextValue.create("world", Level.class);
    public static final ContextValue<InteractionHand> HAND = ContextValue.create("hand", InteractionHand.class);
    public static final ContextValue<HitResult> RAYTRACE_RESULT = ContextValue.create("raytraceResult", HitResult.class);
    public static final ContextValue<BlockPos> HIT_POS = ContextValue.create("hitPos", BlockPos.class);
    public static final ContextValue<Direction> HIT_FACE = ContextValue.create("hitFace", Direction.class);
    public static final ContextValue<Vec3> HIT_VEC = ContextValue.create("hitVec", Vec3.class);
    public static final ContextValue<Boolean> HIT_INSIDE = ContextValue.create("hitInside", Boolean.class);
    public static final ContextValue<Entity> HIT_ENTITY = ContextValue.create("hitEntity", Entity.class);
    public static final ContextValue<Integer> SLOT = ContextValue.create("slot", Integer.class);
    public static final ContextValue<Boolean> SELECTED = ContextValue.create("selected", Boolean.class);
    public static final ContextValue<Entity> OTHER_USER = ContextValue.create("other_user", Entity.class);
    public static final ContextValue<Integer> TIME_LEFT = ContextValue.create("timeLeft", Integer.class);
    public static final ContextValue<BlockPos> BLOCK_POS = ContextValue.create("blockPos", BlockPos.class);
    public static final ContextValue<BlockState> BLOCK_STATE = ContextValue.create("blockState", BlockState.class);
    public static final ContextValue<Entity> ATTACKER = ContextValue.create("attacker", Entity.class);
    public static final ContextValue<Entity> TARGET = ContextValue.create("target", Entity.class);
    public static final ContextValue<Enchantment> ENCHANTMENT = ContextValue.create("enchantment", Enchantment.class);
    public static final ContextValue<Integer> ENCHANTMENT_LEVEL = ContextValue.create("enchantment_level", Integer.class);
    private final Map<ContextValue<?>, Object> parameters = Maps.newHashMap();

    public ItemStack getStack() {
        return this.get(STACK);
    }

    public <T> FlexEventContext with(ContextValue<T> key, T value) {
        this.parameters.put(key, value);
        return this;
    }

    public FlexEventContext withRayTrace(HitResult rayTraceResult) {
        if (rayTraceResult.m_6662_() == HitResult.Type.ENTITY) {
            return this.withRayTrace((EntityHitResult)rayTraceResult);
        }
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            return this.withRayTrace((BlockHitResult)rayTraceResult);
        }
        return this.with(RAYTRACE_RESULT, rayTraceResult).with(HIT_VEC, rayTraceResult.m_82450_());
    }

    public FlexEventContext withRayTrace(BlockHitResult rayTraceResult) {
        return this.with(RAYTRACE_RESULT, rayTraceResult).with(HIT_POS, rayTraceResult.m_82425_()).with(HIT_FACE, rayTraceResult.m_82434_()).with(HIT_VEC, rayTraceResult.m_82450_()).with(HIT_INSIDE, rayTraceResult.m_82436_());
    }

    public FlexEventContext withRayTrace(EntityHitResult rayTraceResult) {
        return this.with(RAYTRACE_RESULT, rayTraceResult).with(HIT_ENTITY, rayTraceResult.m_82443_()).with(HIT_VEC, rayTraceResult.m_82450_());
    }

    public FlexEventContext withHand(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        return this.with(USER, player).with(HAND, hand).with(STACK, held);
    }

    public <T> boolean has(ContextValue<T> key) {
        return this.parameters.containsKey(key);
    }

    public <T> T get(ContextValue<T> key) {
        return (T)this.parameters.get(key);
    }

    public Set<ContextValue<?>> keySet() {
        return this.parameters.keySet();
    }

    public static FlexEventContext of(UseOnContext ctx) {
        FlexEventContext eventContext = new FlexEventContext().with(STACK, ctx.m_43722_()).with(WORLD, ctx.m_43725_()).with(HAND, ctx.m_43724_()).with(HIT_POS, ctx.m_8083_()).with(HIT_FACE, ctx.m_43719_()).with(HIT_VEC, ctx.m_43720_()).with(HIT_INSIDE, ctx.m_43721_());
        Player player = ctx.m_43723_();
        if (player != null) {
            eventContext.with(USER, player);
        }
        return eventContext;
    }

    public static FlexEventContext of(ItemStack stack) {
        return new FlexEventContext().with(STACK, stack);
    }

    public static FlexEventContext of(Level world, LivingEntity user, ItemStack stack) {
        return new FlexEventContext().with(STACK, stack).with(WORLD, world).with(USER, user);
    }

    public static FlexEventContext of(Level world, LivingEntity user, InteractionHand hand, ItemStack stack) {
        return new FlexEventContext().with(STACK, stack).with(WORLD, world).with(USER, user).with(HAND, hand);
    }

    public static FlexEventContext of(Level world, Entity entity, ItemStack stack) {
        if (entity instanceof LivingEntity) {
            return new FlexEventContext().with(STACK, stack).with(WORLD, world).with(USER, (LivingEntity)entity);
        }
        return new FlexEventContext().with(STACK, stack).with(WORLD, world).with(OTHER_USER, entity);
    }

    public static FlexEventContext of(Level world, BlockPos pos, BlockState state) {
        return new FlexEventContext().with(WORLD, world).with(BLOCK_POS, pos).with(BLOCK_STATE, state);
    }

    public static FlexEventContext of(Enchantment enchantment, int level) {
        return new FlexEventContext().with(ENCHANTMENT, enchantment).with(ENCHANTMENT_LEVEL, level);
    }
}

