/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.fluids;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class FlexFlowingFluid
extends FlowingFluid
implements IFlexFluid {
    private final Fluid flowing;
    private final int slopeDistance;
    private final int dropOff;
    private final boolean canConvertToSource;
    private final int tickDelay;
    private final float explosionResistance;
    private final Supplier<Block> block;
    private final Map<String, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private Supplier<Item> bucketItem = () -> Items.f_41852_;
    private Supplier<FluidType> fluidType;

    public FlexFlowingFluid(Supplier<FluidType> fluidType, final List<Property<?>> properties, Map<Property<?>, Comparable<?>> propertyDefaultValues, int slopeDistance, int dropOff, boolean canConvertToSource, int tickDelay, float explosionResistance, Supplier<Block> block) {
        this.fluidType = fluidType;
        this.slopeDistance = slopeDistance;
        this.dropOff = dropOff;
        this.canConvertToSource = canConvertToSource;
        this.tickDelay = tickDelay;
        this.explosionResistance = explosionResistance;
        this.block = block;
        this.initializeFlex(propertyDefaultValues);
        this.flowing = new Flowing(this, propertyDefaultValues){

            @Override
            protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder1) {
                super.m_7180_(builder1);
                properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (propertyDefaultValues.size() > 0) {
            FluidState def = (FluidState)this.m_76144_().m_61090_();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (FluidState)def.m_61124_(prop, value);
            }
            this.m_76142_(def);
        }
    }

    @Override
    public void addEventHandler(String eventName, FlexEventHandler eventHandler) {
        this.eventHandlers.put(eventName, eventHandler);
    }

    @Override
    public FlexEventHandler getEventHandler(String eventName) {
        return this.eventHandlers.get(eventName);
    }

    @Override
    public void setBucketItem(Supplier<Item> bucketItem) {
        this.bucketItem = bucketItem;
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }

    public Item m_6859_() {
        return this.bucketItem.get();
    }

    public boolean m_6212_(Fluid pFluid) {
        return pFluid == this.m_5613_() || pFluid == this.m_5615_();
    }

    protected boolean m_5486_(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
        return pDirection == Direction.DOWN && !this.m_6212_(pFluid);
    }

    public int m_6718_(LevelReader level) {
        return this.tickDelay;
    }

    protected float m_6752_() {
        return this.explosionResistance;
    }

    public BlockState m_5804_(FluidState pState) {
        Block b = this.block.get();
        if (b == Blocks.f_50016_) {
            return b.m_49966_();
        }
        return (BlockState)b.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(FlexFlowingFluid.m_76092_((FluidState)pState)));
    }

    public int m_7430_(FluidState state) {
        return 8;
    }

    public boolean m_7444_(FluidState state) {
        return true;
    }

    public Fluid m_5615_() {
        return this.flowing;
    }

    public Fluid m_5613_() {
        return this;
    }

    protected boolean m_6760_() {
        return this.canConvertToSource;
    }

    protected void m_7456_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        InteractionResult result = InteractionResult.PASS;
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            result = this.runEvent("before_destroy", FlexEventContext.of(level, pPos, pState), FlexEventResult::pass).result();
        }
        if (result == InteractionResult.PASS) {
            BlockEntity blockentity = pState.m_155947_() ? pLevel.m_7702_(pPos) : null;
            Block.m_49892_((BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos, (BlockEntity)blockentity);
        }
    }

    protected int m_6719_(LevelReader pLevel) {
        return this.slopeDistance;
    }

    protected int m_6713_(LevelReader pLevel) {
        return this.dropOff;
    }

    @Nonnull
    public Optional<SoundEvent> m_142520_() {
        return Optional.ofNullable(this.getFluidType().getSound(SoundActions.BUCKET_FILL));
    }

    public static class Flowing
    extends FlowingFluid {
        private final FlexFlowingFluid parent;

        public Flowing(FlexFlowingFluid parent, Map<Property<?>, Comparable<?>> propertyDefaultValues) {
            this.parent = parent;
            this.initializeFlex(propertyDefaultValues);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public boolean m_6212_(Fluid pFluid) {
            return pFluid == this.m_5613_() || pFluid == this.m_5615_();
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
            if (propertyDefaultValues.size() > 0) {
                FluidState def = (FluidState)this.m_76144_().m_61090_();
                for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                    Property<?> prop = entry.getKey();
                    Comparable<?> value = entry.getValue();
                    def = (FluidState)def.m_61124_(prop, value);
                }
                this.m_76142_(def);
            }
        }

        public FluidType getFluidType() {
            return this.parent.getFluidType();
        }

        public Item m_6859_() {
            return this.parent.m_6859_();
        }

        protected boolean m_5486_(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
            return pDirection == Direction.DOWN && !this.m_6212_(pFluid);
        }

        public int m_6718_(LevelReader p_76120_) {
            return this.parent.m_6718_(p_76120_);
        }

        protected float m_6752_() {
            return this.parent.m_6752_();
        }

        protected BlockState m_5804_(FluidState pState) {
            return this.parent.m_5804_(pState);
        }

        public Fluid m_5615_() {
            return this.parent.m_5615_();
        }

        public Fluid m_5613_() {
            return this.parent.m_5613_();
        }

        protected boolean m_6760_() {
            return this.parent.m_6760_();
        }

        protected void m_7456_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
            this.parent.m_7456_(pLevel, pPos, pState);
        }

        protected int m_6719_(LevelReader pLevel) {
            return this.parent.m_6719_(pLevel);
        }

        protected int m_6713_(LevelReader pLevel) {
            return this.parent.m_6713_(pLevel);
        }
    }
}

