/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.BlockBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.properties.PropertyType;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.MaterialColors;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockParser
extends ThingParser<BlockBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public BlockParser(IEventBus bus) {
        super(GSON, "block");
        bus.addListener(this::register);
    }

    public void register(RegisterEvent event) {
        event.register(Registry.f_122901_, helper -> {
            LOGGER.info("Started registering Block things, errors about unexpected registry domains are harmless...");
            BlockParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> helper.register(thing.getRegistryName(), (Object)((IFlexBlock)thing.get()).self()), BaseBuilder::getRegistryName);
            LOGGER.info("Done processing thingpack Blocks.");
        });
    }

    @Override
    public BlockBuilder processThing(ResourceLocation key, JsonObject data, Consumer<BlockBuilder> builderModification) {
        BlockBuilder builder = BlockBuilder.begin(this, key);
        MutableObject propertiesByName = new MutableObject(new HashMap());
        MutableObject facingProperty = new MutableObject();
        JParse.begin(data).ifKey("parent", val -> val.string().map(ResourceLocation::new).handle(builder::setParent)).ifKey("type", val -> val.string().map(ResourceLocation::new).handle(builder::setBlockType)).ifKey("material", val -> val.string().map(ResourceLocation::new).handle(builder::setMaterial)).ifKey("map_color", val -> val.ifString(str -> builder.setMaterialColor(MaterialColors.get(str.getAsString()))).ifInteger(str -> builder.setMaterialColor(MaterialColor.f_76387_[str.range(0, 64).getAsInt()])).typeError()).ifKey("requires_tool_for_drops", val -> val.bool().handle(builder::setRequiresToolForDrops)).ifKey("is_air", val -> val.bool().handle(builder::setIsAir)).ifKey("has_collision", val -> val.bool().handle(builder::setHasCollision)).ifKey("ticks_randomly", val -> val.bool().handle(builder::setTicksRandom)).ifKey("light_emission", val -> val.intValue().range(0, 16).handle(builder::setLightEmission)).ifKey("explosion_resistance", val -> val.floatValue().min(0.0f).handle(builder::setExplosionResistance)).ifKey("destroy_time", val -> val.floatValue().min(0.0f).handle(builder::setDestroyTime)).ifKey("friction", val -> val.floatValue().range(0.0f, 1.0f).handle(builder::setFriction)).ifKey("speed_factor", val -> val.floatValue().range(0.0f, 1.0f).handle(builder::setSpeedFactor)).ifKey("jump_factor", val -> val.floatValue().range(0.0f, 1.0f).handle(builder::setJumpFactor)).ifKey("sound_type", val -> val.string().map(ResourceLocation::new).handle(builder::setSoundType)).ifKey("properties", val -> val.obj().map(this::parseProperties).handle(properties -> {
            propertiesByName.setValue(properties);
            builder.setProperties((Map<String, Property<?>>)properties);
        })).ifKey("default_state", val -> val.obj().raw(obj -> this.parseBlockState((JsonObject)obj, builder))).ifKey("shape_rotation", val -> val.string().handle(name -> {
            Property<?> prop = this.getRotationProperty((MutableObject<Map<String, Property<?>>>)propertiesByName, (String)name);
            facingProperty.setValue(prop);
        })).ifKey("shape", val -> val.raw(obj -> builder.setGeneralShape(DynamicShape.parseShape(obj, (Property<Direction>)((Property)facingProperty.getValue()), (Map)propertiesByName.getValue())))).ifKey("collision_shape", val -> val.raw(obj -> builder.setCollisionShape(DynamicShape.parseShape(obj, (Property<Direction>)((Property)facingProperty.getValue()), (Map)propertiesByName.getValue())))).ifKey("raytrace_shape", val -> val.raw(obj -> builder.setRaytraceShape(DynamicShape.parseShape(obj, (Property<Direction>)((Property)facingProperty.getValue()), (Map)propertiesByName.getValue())))).ifKey("render_shape", val -> val.raw(obj -> builder.setRenderShape(DynamicShape.parseShape(obj, (Property<Direction>)((Property)facingProperty.getValue()), (Map)propertiesByName.getValue())))).ifKey("not_solid", val -> val.bool().handle(builder::setSeeThrough)).ifKey("color_handler", val -> val.string().handle(builder::setColorHandler)).ifKey("item", val -> BlockParser.parseItemBlock(builder, val)).ifKey("events", val -> val.obj().map(this::parseEvents).handle(builder::setEventMap));
        builderModification.accept(builder);
        builder.setFactory(builder.getBlockType().getFactory(data));
        return builder;
    }

    private Property<?> getRotationProperty(MutableObject<Map<String, Property<?>>> propertiesByName, String name) {
        Property prop = (Property)((Map)propertiesByName.getValue()).get(name);
        if (prop == null) {
            throw new ThingParseException("No property with name '" + name + "' declared in block.");
        }
        if (prop.m_61709_() != Direction.class) {
            throw new ThingParseException("The specified shape_rotation property is not a Direction property.");
        }
        return prop;
    }

    private void parseBlockState(JsonObject props, BlockBuilder builder) {
        for (Map.Entry entry : props.entrySet()) {
            String name = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            builder.setPropertyDefaultValue(name, value.getAsString());
        }
    }

    private Map<String, Property<?>> parseProperties(ObjValue props) {
        HashMap map = new HashMap();
        props.forEach((name, val) -> val.ifString(str -> str.handle(prop -> {
            Property property = (Property)ThingRegistries.PROPERTIES.m_7745_(new ResourceLocation(prop));
            if (property == null) {
                throw new ThingParseException("Property with name " + prop + " not found in ThingRegistries.PROPERTIES");
            }
            if (!property.m_61708_().equals(name)) {
                throw new ThingParseException("The stock property '" + prop + "' does not have the expected name '" + name + "' != '" + property.m_61708_() + "'");
            }
            map.put((String)name, (Property<?>)property);
        })).ifObj(obj -> obj.raw(rawObj -> map.put((String)name, PropertyType.deserialize(name, rawObj)))).typeError());
        return map;
    }

    public static void parseItemBlock(BlockBuilder builder, Any val) {
        val.ifBool(v -> v.handle(b -> {
            if (b) {
                BlockParser.createItemBlock(builder, new JsonObject());
            }
        })).ifObj(obj -> obj.raw(item -> BlockParser.createItemBlock(builder, item))).typeError();
    }

    private static void createItemBlock(BlockBuilder builder, JsonObject obj) {
        try {
            ItemBuilder itemBuilder = JsonThings.itemParser.parseFromElement(builder.getRegistryName(), (JsonElement)obj, b -> {
                if (!b.hasType()) {
                    b.setType(FlexItemType.BLOCK);
                }
            });
            if (itemBuilder != null) {
                builder.setItem(itemBuilder);
            }
        }
        catch (Exception e) {
            throw new ThingParseException("Exception while parsing nested item in " + builder.getRegistryName(), e);
        }
    }
}

