/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.QueueableExecutor;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.CustomPackType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Unit;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class ThingResourceManager {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> disabledPacks = Sets.newHashSet();
    private QueueableExecutor mainThreadExecutor;
    private final ReloadableResourceManager resourceManager;
    private final RepositorySource folderPackFinder;
    private final PackRepository packList;
    private final List<ThingParser<?>> thingParsers = Lists.newArrayList();
    private final Map<String, ThingParser<?>> parsersMap = Maps.newHashMap();
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);

    public static ThingResourceManager instance() {
        return InstanceHolder.instance;
    }

    @Deprecated(forRemoval=true)
    public static ThingResourceManager initialize(IEventBus modBusEvent) {
        return InstanceHolder.instance;
    }

    private ThingResourceManager() {
        this.resourceManager = new ReloadableResourceManager(CustomPackType.THINGS);
        this.folderPackFinder = new FolderRepositorySource(this.getThingPacksLocation().toFile(), PackSource.f_10527_);
        this.packList = new PackRepository(CustomPackType.THINGS, new RepositorySource[]{this.folderPackFinder});
    }

    public synchronized <TParser extends ThingParser<?>> TParser registerParser(TParser parser) {
        if (this.parsersMap.containsKey(parser.getThingType())) {
            throw new IllegalStateException("There is already a parser registered for type " + parser.getThingType());
        }
        this.thingParsers.add(parser);
        this.resourceManager.m_7217_(parser);
        this.parsersMap.put(parser.getThingType(), parser);
        return parser;
    }

    public RepositorySource getWrappedPackFinder() {
        return (infoConsumer, infoFactory) -> this.folderPackFinder.m_7686_(info -> {
            if (!disabledPacks.contains(info.m_10446_())) {
                infoConsumer.accept(info);
            }
        }, (a, n, b, c, d, e, f, g) -> infoFactory.create("thingpack:" + a, n, true, c, d, e, f, g));
    }

    public Path getThingPacksLocation() {
        Path thingpacks = FMLPaths.GAMEDIR.get().resolve("thingpacks");
        if (!Files.exists(thingpacks, new LinkOption[0]) && !thingpacks.toFile().mkdirs()) {
            throw new ThingParseException("Could not create thingspacks directory! Please create the directory yourself, or make sure the name is not taken by a file and you have permission to create directories.");
        }
        return thingpacks;
    }

    public synchronized void addPackFinder(RepositorySource finder) {
        this.packList.addPackFinder(finder);
    }

    public synchronized void addResourceReloadListener(PreparableReloadListener listener) {
        this.resourceManager.m_7217_(listener);
    }

    public CompletableFuture<ThingResourceManager> beginLoading() {
        this.packList.m_10506_();
        this.loadConfig();
        this.mainThreadExecutor = new QueueableExecutor();
        return ((CompletableFuture)((CompletableFuture)this.resourceManager.m_142463_((Executor)Util.m_183991_(), (Executor)this.mainThreadExecutor, RESOURCE_RELOAD_INITIAL_TASK, this.packList.m_10525_()).m_7237_().whenComplete((unit, throwable) -> {
            if (throwable != null) {
                this.resourceManager.close();
            }
        })).thenRun(this.mainThreadExecutor::finish)).thenApply(unit -> this);
    }

    public void waitForLoading(CompletableFuture<ThingResourceManager> loaderFuture) {
        try {
            while (!loaderFuture.isDone()) {
                this.mainThreadExecutor.runQueue();
                this.mainThreadExecutor.waitForTasks();
            }
            this.mainThreadExecutor.runQueue();
            loaderFuture.get().finishLoading();
        }
        catch (InterruptedException e) {
            LOGGER.error("Thingpack loader future interrupted!");
        }
        catch (ExecutionException e) {
            Throwable pCause = e.getCause();
            throw new ReportedException(CrashReport.m_127521_((Throwable)pCause, (String)"Error loading thingpacks"));
        }
    }

    public void finishLoading() {
        this.thingParsers.forEach(ThingParser::finishLoading);
    }

    public PackRepository getRepository() {
        return this.packList;
    }

    public void onConfigScreenSave() {
        disabledPacks.clear();
        disabledPacks.addAll(this.packList.m_10514_());
        disabledPacks.removeAll(this.packList.m_10523_());
        this.saveConfig();
    }

    public void saveConfig() {
        JsonArray disabled = new JsonArray();
        disabledPacks.forEach(arg_0 -> ((JsonArray)disabled).add(arg_0));
        JsonArray order = new JsonArray();
        this.packList.m_10523_().forEach(arg_0 -> ((JsonArray)order).add(arg_0));
        JsonObject obj = new JsonObject();
        obj.add("disabled", (JsonElement)disabled);
        obj.add("order", (JsonElement)order);
        String json = new Gson().toJson((JsonElement)obj);
        try (FileOutputStream stream = new FileOutputStream(this.getConfigFile());
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            w.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        File configFile = this.getConfigFile();
        ArrayList<String> orderList = new ArrayList<String>();
        if (configFile.exists()) {
            try (FileInputStream stream = new FileInputStream(configFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                JsonArray disabled = obj.get("disabled").getAsJsonArray();
                disabledPacks.clear();
                disabled.forEach(element -> disabledPacks.add(element.getAsString()));
                JsonArray order = obj.get("order").getAsJsonArray();
                order.forEach(element -> orderList.add(element.getAsString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String s : this.packList.m_10514_()) {
            if (orderList.contains(s) || disabledPacks.contains(s)) continue;
            orderList.add(s);
        }
        this.packList.m_10509_(orderList);
    }

    private File getConfigFile() {
        return FMLPaths.CONFIGDIR.get().resolve("jsonthings-thingpacks.json").toFile();
    }

    private static class InstanceHolder {
        private static final ThingResourceManager instance = new ThingResourceManager();

        private InstanceHolder() {
        }
    }
}

