/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.blocks.FlexBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceGateBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexHorizontalDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLeavesBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLiquidBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexRotatedPillarBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSaplingBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSlabBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexStairsBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexTrapdoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexWallBlock;
import dev.gigaherz.jsonthings.things.builders.BlockBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexTreeGrower;
import dev.gigaherz.jsonthings.things.serializers.IBlockFactory;
import dev.gigaherz.jsonthings.things.serializers.IBlockSerializer;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexBlockType<T extends Block> {
    public static final FlexBlockType<FlexBlock> PLAIN = FlexBlockType.register("plain", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[0]);
    public static final FlexBlockType<FlexSaplingBlock> SAPLING = FlexBlockType.register("sapling", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        ResourceLocation featureId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"tree_feature"));
        ResourceKey featureKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)featureId);
        FlexTreeGrower treeGrower = new FlexTreeGrower(featureKey);
        return new FlexSaplingBlock(treeGrower, props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout", false, Material.f_76300_, new Property[0]);
    public static final FlexBlockType<FlexDirectionalBlock> DIRECTIONAL = FlexBlockType.register("directional", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexDirectionalBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{DirectionalBlock.f_52588_});
    public static final FlexBlockType<FlexHorizontalDirectionalBlock> HORIZONTAL_DIRECTIONAL = FlexBlockType.register("horizontal_directional", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexHorizontalDirectionalBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{HorizontalDirectionalBlock.f_54117_});
    public static final FlexBlockType<FlexRotatedPillarBlock> ROTATED_PILLAR = FlexBlockType.register("rotated_pillar", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexRotatedPillarBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{RotatedPillarBlock.f_55923_});
    public static final FlexBlockType<FlexSlabBlock> SLAB = FlexBlockType.register("slab", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexSlabBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{SlabBlock.f_56353_, SlabBlock.f_56354_});
    public static final FlexBlockType<FlexStairsBlock> STAIRS = FlexBlockType.register("stairs", data -> {
        MutableObject parent = new MutableObject();
        JParse.begin(data).ifKey("stairs_parent", val -> val.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)parent).setValue(arg_0)));
        return (props, builder) -> {
            ResourceLocation parentName = (ResourceLocation)parent.getValue();
            if (parentName == null) {
                BlockBuilder parentBuilder = (BlockBuilder)builder.getParent();
                if (parentBuilder == null) {
                    throw new IllegalStateException("Stairs blocks need a parent block, but none has been declared.");
                }
                parentName = parentBuilder.getRegistryName();
            }
            RegistryObject parentBlock = RegistryObject.create((ResourceLocation)parentName, (IForgeRegistry)ForgeRegistries.BLOCKS);
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            return new FlexStairsBlock(props, propertyDefaultValues, () -> ((Block)parentBlock.get()).m_49966_()){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "solid", false, Material.f_76278_, new Property[]{StairBlock.f_56841_, StairBlock.f_56842_, StairBlock.f_56843_, StairBlock.f_56844_});
    public static final FlexBlockType<FlexWallBlock> WALL = FlexBlockType.register("wall", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexWallBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{WallBlock.f_57949_, WallBlock.f_57950_, WallBlock.f_57951_, WallBlock.f_57952_, WallBlock.f_57953_, WallBlock.f_57954_});
    public static final FlexBlockType<FlexFenceBlock> FENCE = FlexBlockType.register("fence", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexFenceBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{FenceBlock.f_52309_, FenceBlock.f_52310_, FenceBlock.f_52311_, FenceBlock.f_52312_, FenceBlock.f_52313_});
    public static final FlexBlockType<FlexFenceGateBlock> FENCE_GATE = FlexBlockType.register("fence_gate", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexFenceGateBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, Material.f_76278_, new Property[]{FenceGateBlock.f_53341_, FenceGateBlock.f_53342_, FenceGateBlock.f_53343_});
    public static final FlexBlockType<FlexLeavesBlock> LEAVES = FlexBlockType.register("leaves", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexLeavesBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout_mipped", true, Material.f_76274_, new Property[]{LeavesBlock.f_54418_, LeavesBlock.f_54419_});
    public static final FlexBlockType<FlexDoorBlock> DOOR = FlexBlockType.register("door", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexDoorBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout", true, Material.f_76278_, new Property[]{DoorBlock.f_52726_, DoorBlock.f_52727_, DoorBlock.f_52728_, DoorBlock.f_52729_, DoorBlock.f_52730_});
    public static final FlexBlockType<FlexTrapdoorBlock> TRAPDOOR = FlexBlockType.register("trapdoor", data -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexTrapdoorBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout", true, Material.f_76278_, new Property[]{TrapDoorBlock.f_57514_, TrapDoorBlock.f_57515_, TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_});
    public static final FlexBlockType<FlexLiquidBlock> LIQUID = FlexBlockType.register("liquid", data -> {
        ObjValue extras = JParse.begin(data);
        MutableObject fluid = new MutableObject();
        extras.key("fluid", any -> any.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)fluid).setValue(arg_0)));
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            ResourceLocation fluidName = fluid.getValue() != null ? (ResourceLocation)fluid.getValue() : builder.getRegistryName();
            Lazy fluidSupplier = Lazy.of(() -> {
                Fluid fluidObj = (Fluid)Utils.getOrCrash(ForgeRegistries.FLUIDS, fluidName);
                if (!(fluidObj instanceof FlowingFluid)) {
                    throw new RuntimeException("LiquidBlock requires a flowing fluid");
                }
                FlowingFluid flowing = (FlowingFluid)fluidObj;
                return flowing;
            });
            return new FlexLiquidBlock(props, propertyDefaultValues, (Supplier)fluidSupplier){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "translucent", true, Material.f_76305_, new Property[0]);
    private final IBlockSerializer<T> factory;
    private final List<Property<?>> stockProperties;
    private final String defaultLayer;
    private final boolean defaultSeeThrough;
    private final Material defaultMaterial;

    public static void init() {
    }

    public static <T extends Block> FlexBlockType<T> register(String name, IBlockSerializer<T> factory, String defaultLayer, boolean defaultSeeThrough, Material defaultMaterial, Property<?> ... stockProperties) {
        return (FlexBlockType)Registry.m_122961_(ThingRegistries.BLOCK_TYPES, (String)name, new FlexBlockType<T>(factory, Arrays.asList(stockProperties), defaultLayer, defaultSeeThrough, defaultMaterial));
    }

    private FlexBlockType(IBlockSerializer<T> factory, List<Property<?>> stockProperties, String defaultLayer, boolean defaultSeeThrough, Material defaultMaterial) {
        this.factory = factory;
        this.stockProperties = stockProperties;
        this.defaultLayer = defaultLayer;
        this.defaultSeeThrough = defaultSeeThrough;
        this.defaultMaterial = defaultMaterial;
    }

    public IBlockFactory<T> getFactory(JsonObject data) {
        return this.factory.createFactory(data);
    }

    public List<Property<?>> getStockProperties() {
        return this.stockProperties;
    }

    public String getDefaultLayer() {
        return this.defaultLayer;
    }

    public boolean isDefaultSeeThrough() {
        return this.defaultSeeThrough;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public String toString() {
        return "BlockType{" + ThingRegistries.BLOCK_TYPES.m_7981_((Object)this) + "}";
    }
}

