/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class CodecExtras {
    public static final Codec<Property<?>> PROPERTY_CODEC = CodecExtras.registryNameCodec(ThingRegistries.PROPERTIES);
    public static final Codec<DoubleStream> DOUBLE_STREAM = Codec.DOUBLE.listOf().xmap(list -> list.stream().mapToDouble(d -> d), stream -> stream.boxed().collect(Collectors.toList()));

    public static DataResult<double[]> validateDoubleStreamSize(DoubleStream stream, int size) {
        double[] aint = stream.limit(size + 1).toArray();
        if (aint.length != size) {
            String s = "Input is not a list of " + size + " ints";
            return aint.length >= size ? DataResult.error((String)s, (Object)Arrays.copyOf(aint, size)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)aint);
    }

    public static <T> Codec<List<T>> maybeList(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(left -> left, Collections::singletonList), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left((Object)list));
    }

    public static <K, V> Codec<V> mappingCodec(Codec<K> keyCodec, Function<K, V> lookup, Function<V, K> inverseLookup) {
        return keyCodec.flatXmap(key -> {
            Object value = lookup.apply(key);
            return value != null ? DataResult.success(value) : DataResult.error((String)"The map does not contain any value with the given key");
        }, value -> {
            Object key = inverseLookup.apply(value);
            return key != null ? DataResult.success(key) : DataResult.error((String)"Could not find a key in the map for the given value");
        });
    }

    public static <T> Codec<T> registryNameCodec(Registry<T> registry) {
        return CodecExtras.mappingCodec(ResourceLocation.f_135803_, arg_0 -> registry.m_7745_(arg_0), arg_0 -> registry.m_7981_(arg_0));
    }

    public static <R, T extends R> Codec<R> toSubclass(Codec<T> codec, Class<T> subclass) {
        return codec.flatComapMap(m -> m, v -> subclass.isInstance(v) ? DataResult.success(subclass.cast(v)) : DataResult.error((String)("Value " + v + "is not of type " + subclass.getName())));
    }

    @SafeVarargs
    public static <T> Codec<T> makeChoiceCodec(final Codec<T> _choice, final Codec<T> ... _choices) {
        return new Codec<T>(){
            final List<Codec<T>> choices;
            {
                this.choices = (List)Stream.concat(Stream.of(_choice), Arrays.stream(_choices)).collect(ImmutableList.toImmutableList());
            }

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                return this.processChoices(choice -> choice.decode(ops, input), "Could not decode with any of the options.");
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return this.processChoices(choice -> choice.encode(input, ops, prefix), "Could not encode with any of the options.");
            }

            private <T1> DataResult<T1> processChoices(Function<Codec<T>, DataResult<T1>> action, String errMessage) {
                StringBuilder builder = null;
                for (Codec choice : this.choices) {
                    DataResult<T1> result = action.apply(choice);
                    Optional success = result.result();
                    if (success.isPresent()) {
                        return DataResult.success(success.get());
                    }
                    StringBuilder b = builder == null ? new StringBuilder() : builder;
                    Optional error = result.error();
                    error.ifPresent(err -> {
                        b.append("\n");
                        b.append(err.message());
                    });
                }
                if (builder != null) {
                    builder.append("\nEnd choices.");
                    return DataResult.error((String)(errMessage + " Errors: " + builder));
                }
                return DataResult.error((String)"No codecs?!");
            }

            public String toString() {
                return String.format("ChoiceCodec[%s]", this.choices.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        };
    }

    public static <T> Codec<T> lazy(final Supplier<Codec<T>> codecSupplier) {
        return new Codec<T>(){
            final Supplier<Codec<T>> supplier;
            Codec<T> resolved;
            {
                this.supplier = codecSupplier;
                this.resolved = null;
            }

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                return (this.resolved == null ? (this.resolved = this.supplier.get()) : this.resolved).decode(ops, input);
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                return (this.resolved == null ? (this.resolved = this.supplier.get()) : this.resolved).encode(input, ops, prefix);
            }

            public String toString() {
                if (this.resolved != null) {
                    return String.format("LazyCodec[%s]", this.resolved);
                }
                return "LazyCodec[not resolved]";
            }
        };
    }
}

