/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util.parse.value;

import java.util.function.Consumer;
import java.util.function.Function;

public interface MappedValue<T> {
    public static <T> MappedValue<T> of(T value) {
        return new Impl<T>(value);
    }

    public T value();

    default public void handle(Consumer<T> visitor) {
        visitor.accept(this.value());
    }

    default public <R> MappedValue<R> map(Function<T, R> mapping) {
        return MappedValue.of(mapping.apply(this.value()));
    }

    public record Impl<T>(T value) implements MappedValue<T>
    {
    }
}

