/*
 * Decompiled with CFR 0.152.
 */
package birsy.foglooksgoodnow.client;

import birsy.foglooksgoodnow.client.FogManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="foglooksgoodnow", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        if (event.getCamera().m_167685_() == FogType.NONE) {
            FogManager densityManager = FogManager.getDensityManager();
            float renderDistance = event.getRenderer().m_109152_();
            float undergroundFogMultiplier = 1.0f;
            if (FogManager.shouldRenderCaveFog()) {
                undergroundFogMultiplier = (float)Mth.m_14139_((double)densityManager.getUndergroundFactor((float)event.getPartialTick()), (double)densityManager.caveFogMultiplier, (double)1.0);
                float darkness = densityManager.darkness.get((float)event.getPartialTick());
                undergroundFogMultiplier = Mth.m_14179_((float)darkness, (float)undergroundFogMultiplier, (float)1.0f);
            }
            RenderSystem.m_157445_((float)(renderDistance * densityManager.fogStart.get((float)event.getPartialTick())));
            RenderSystem.m_157443_((float)(renderDistance * densityManager.fogEnd.get((float)event.getPartialTick()) * undergroundFogMultiplier));
            RenderSystem.m_202160_((FogShape)FogShape.SPHERE);
        }
    }

    @SubscribeEvent
    public static void onRenderFogColors(ViewportEvent.ComputeFogColor event) {
        if (FogManager.shouldRenderCaveFog()) {
            FogManager densityManager = FogManager.getDensityManager();
            Vec3 fogColor = FogManager.getCaveFogColor();
            float undergroundFactor = 1.0f - densityManager.getUndergroundFactor((float)event.getPartialTick());
            event.setRed((float)Mth.m_14139_((double)undergroundFactor, (double)event.getRed(), (double)(fogColor.f_82479_ * densityManager.unlitFogColor.m_7096_())));
            event.setGreen((float)Mth.m_14139_((double)undergroundFactor, (double)event.getGreen(), (double)(fogColor.f_82480_ * densityManager.unlitFogColor.m_7098_())));
            event.setBlue((float)Mth.m_14139_((double)undergroundFactor, (double)event.getBlue(), (double)(fogColor.f_82481_ * densityManager.unlitFogColor.m_7094_())));
        }
    }
}

