/*
 * Decompiled with CFR 0.152.
 */
package birsy.foglooksgoodnow.util;

import com.ibm.icu.impl.Pair;
import com.mojang.math.Vector3f;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class MathUtils {
    private static final float[] ASIN = (float[])Util.m_137469_((Object)new float[65536], array -> {
        for (int i = 0; i < ((float[])array).length; ++i) {
            array[i] = (float)Math.sin((double)i * Math.PI * 2.0 / (double)((float[])array).length);
        }
    });

    public static float arcsin(float pValue) {
        return ASIN[(int)(pValue * 10430.378f) & 0xFFFF];
    }

    public static float arccos(float pValue) {
        return (float)((double)(MathUtils.arcsin(pValue) * -1.0f) + 1.5707963267948966);
    }

    public static Vec3 vec3Lerp(float delta, Vec3 start, Vec3 end) {
        return new Vec3(Mth.m_14139_((double)delta, (double)start.m_7096_(), (double)end.m_7096_()), Mth.m_14139_((double)delta, (double)start.m_7098_(), (double)end.m_7098_()), Mth.m_14139_((double)delta, (double)start.m_7094_(), (double)end.m_7094_()));
    }

    public static Vec3 vec3Lerp(double delta, Vec3 start, Vec3 end) {
        return new Vec3(Mth.m_14139_((double)delta, (double)start.m_7096_(), (double)end.m_7096_()), Mth.m_14139_((double)delta, (double)start.m_7098_(), (double)end.m_7098_()), Mth.m_14139_((double)delta, (double)start.m_7094_(), (double)end.m_7094_()));
    }

    public static Vec3 rotateVectorY(Vec3 vector, float rotation) {
        return new Vec3(vector.f_82479_ * Math.cos(rotation) - vector.f_82481_ * Math.sin(rotation), vector.f_82480_, vector.f_82481_ * Math.cos(rotation) + vector.f_82479_ * Math.sin(rotation));
    }

    public static float mapRange(float fromMin, float fromMax, float toMin, float toMax, float value) {
        return toMin + (value - fromMin) * (toMax - toMin) / (fromMax - fromMin);
    }

    public static double mapRange(double fromMin, double fromMax, double toMin, double toMax, double value) {
        return toMin + (value - fromMin) * (toMax - toMin) / (fromMax - fromMin);
    }

    public static float bias(float value, float bias) {
        float b = (float)Math.pow(1.0f - bias, 3.0);
        return value * b / (value * b - value + 1.0f);
    }

    public static double bias(double value, double bias) {
        if (bias == 0.0) {
            return value;
        }
        double b = Math.pow(1.0 - bias, 3.0);
        return value * b / (value * b - value + 1.0);
    }

    public static float biasTowardsIntegers(float value) {
        float mod = value % 1.0f;
        return (float)((double)(mod * mod * mod * mod) + Math.floor(value));
    }

    public static double biasTowardsExtreme(double value, double bias, int iterations) {
        double result = value;
        for (int i = 0; i < iterations; ++i) {
            result += Math.sin(Math.PI * result) * bias / Math.PI;
        }
        return result;
    }

    public static boolean within(float value, float input, float margin) {
        float difference = Math.abs(value - input);
        return difference <= Math.abs(margin);
    }

    public static float getRandomFloatBetween(Random rand, float min, float max) {
        return MathUtils.mapRange(0.0f, 1.0f, min, max, rand.nextFloat());
    }

    public static float getRandomFloatBetween(RandomSource rand, float min, float max) {
        return MathUtils.mapRange(0.0f, 1.0f, min, max, rand.m_188501_());
    }

    public static float map(float min, float max, float value) {
        return value * (max - min) + min;
    }

    public static double map(double min, double max, double value) {
        return value * (max - min) + min;
    }

    public static Vec3 adjustAxis(Vec3 vector, double desiredLength, Direction.Axis axis) {
        double lSqr = desiredLength * desiredLength;
        switch (axis) {
            case X: {
                return new Vec3(Math.sqrt(lSqr + -1.0 * vector.m_7098_() * vector.m_7098_() + -1.0 * vector.m_7094_() * vector.m_7094_()), vector.m_7098_(), vector.m_7094_());
            }
            case Y: {
                return new Vec3(vector.m_7096_(), Math.sqrt(lSqr + -1.0 * vector.m_7096_() * vector.m_7096_() + -1.0 * vector.m_7094_() * vector.m_7094_()), vector.m_7094_());
            }
        }
        return new Vec3(vector.m_7096_(), vector.m_7098_(), Math.sqrt(lSqr + -1.0 * vector.m_7096_() * vector.m_7096_() + -1.0 * vector.m_7098_() * vector.m_7098_()));
    }

    public static float awfulRandom(float seed) {
        return Mth.m_14187_((float)(Mth.m_14031_((float)((float)((double)seed * Math.tan(Mth.m_14116_((float)Math.abs(seed - seed * 0.5f)))))) * 100000.0f));
    }

    public static Pair<Float, Boolean> terrace(float height, float width, float erosion, float terraceThreshold) {
        float terraceWidth = width * 0.5f;
        if (terraceWidth == 0.0f) {
            terraceWidth += 1.0E-4f;
        }
        float k = (float)Math.floor(height / terraceWidth);
        float f = (height - k * terraceWidth) / terraceWidth;
        float s = Math.min(2.0f * f, 1.0f);
        float secondTerraceThreshold = Math.abs(terraceThreshold - 1.0f);
        boolean isTerrace = s >= terraceThreshold || s <= secondTerraceThreshold;
        return Pair.of((Object)Float.valueOf(Mth.m_14179_((float)erosion, (float)((k + s) * terraceWidth), (float)height)), (Object)isTerrace);
    }

    public static Pair<Float, Float> terrace(float height, float width, float erosion) {
        float terraceWidth = width * 0.5f;
        if (terraceWidth == 0.0f) {
            terraceWidth += 1.0E-4f;
        }
        float k = (float)Math.floor(height / terraceWidth);
        float f = (height - k * terraceWidth) / terraceWidth;
        float s = Math.min(2.0f * f, 1.0f);
        float terraceMultiplier = Mth.m_14036_((float)MathUtils.invert(Math.abs(s - 1.0f)), (float)0.0f, (float)1.0f);
        return Pair.of((Object)Float.valueOf(Mth.m_14179_((float)erosion, (float)((k + s) * terraceWidth), (float)height)), (Object)Float.valueOf(terraceMultiplier));
    }

    public static Pair<Double, Double> terrace(double height, double width, double erosion) {
        double terraceWidth = width * 0.5;
        if (terraceWidth == 0.0) {
            terraceWidth += (double)1.0E-4f;
        }
        double k = (float)Math.floor(height / terraceWidth);
        double f = (height - k * terraceWidth) / terraceWidth;
        double s = Math.min(2.0 * f, 1.0);
        double terraceMultiplier = Mth.m_14008_((double)MathUtils.invert(Math.abs(s - 1.0)), (double)0.0, (double)1.0);
        return Pair.of((Object)Mth.m_14139_((double)erosion, (double)((k + s) * terraceWidth), (double)height), (Object)terraceMultiplier);
    }

    public static float invert(float input) {
        return (1.0f - input) * -1.0f;
    }

    public static double invert(double input) {
        return (1.0 - input) * -1.0;
    }

    public static float lazyPow(float input, int exponentIn) {
        float value = 1.0f;
        for (int exponent = 0; exponent < exponentIn; ++exponent) {
            value *= input;
        }
        return value;
    }

    public static double lazyPow(double input, int exponentIn) {
        double value = 1.0;
        for (int exponent = 0; exponent < exponentIn; ++exponent) {
            value *= input;
        }
        return value;
    }

    public static float minMaxSin(float value, float min, float max) {
        return (Mth.m_14031_((float)value) + 1.0f) * 0.5f * (max - min) + min;
    }

    public static float fastSin(float value) {
        float offset = (float)(Math.ceil(0.3183098861837907 * (double)value) * 2.0 - 1.0);
        float v = (float)(-(4.0 / Math.pow(Math.PI, 2.0)) * Math.pow((double)value - (double)offset * 1.5707963267948966, 2.0) + 1.0);
        if ((double)value % Math.PI * 2.0 / Math.PI < 1.0) {
            return v;
        }
        return -v;
    }

    public static float wave(WaveType type, float x, float frequency, float amplitude) {
        float value = 0.0f;
        switch (type) {
            case sine: {
                value = (float)Math.sin(Math.PI * (double)x / (double)frequency);
            }
            case square: {
                value = 2.0f * (float)Math.round((Math.sin(Math.PI * (double)x / (double)frequency) + 1.0) / 2.0) - 1.0f;
            }
            case triangle: {
                value = -1.0f * (((x + frequency / 2.0f) % (2.0f * frequency) - frequency) / frequency / 2.0f) + 1.0f;
            }
            case sawtooth: {
                value = (x + frequency) % (2.0f * frequency) / frequency - 1.0f;
            }
        }
        value = x;
        return value * amplitude;
    }

    public static float smoothMin(float value1, float value2, float smoothness) {
        if (smoothness == 0.0f) {
            return Math.min(value1, value2);
        }
        float h = value1 - value2;
        return (float)(0.5 * ((double)(value1 + value2) - Math.sqrt(h * h + smoothness)));
    }

    public static float smoothMax(float value1, float value2, float smoothness) {
        float h = (float)(Math.max((double)(smoothness - Math.abs(value1 - value2)), 0.0) / (double)smoothness);
        return (float)((double)Math.max(value1, value2) + (double)(h * h * h * smoothness) * 0.16666666666666666);
    }

    public static double smoothMinExpo(double a, double b, double smoothness) {
        if (smoothness == 0.0) {
            return Math.min(a, b);
        }
        double k = 1.0 / smoothness;
        double res = Math.pow(2.0, -k * a) + Math.pow(2.0, -k * b);
        return -MathUtils.log(2.0, res) / k;
    }

    public static double smoothClampExpo(double value, double min, double max, double smoothness) {
        return MathUtils.smoothMinExpo(MathUtils.smoothMinExpo(value, max, smoothness), min, -smoothness);
    }

    public static double smoothMinExpo2(double smoothness, double ... nums) {
        if (smoothness == 0.0) {
            double min = Double.MAX_VALUE;
            for (double num : nums) {
                min = Math.min(num, min);
            }
            return min;
        }
        double k = 1.0 / smoothness;
        double res = 0.0;
        for (double num : nums) {
            res += Math.pow(2.0, -k * num);
        }
        return -MathUtils.log(2.0, res) / k;
    }

    public static double a_asin(double x) {
        double a0 = 1.5707288;
        double a1 = -0.2121144;
        double a2 = 0.074261;
        double a3 = -0.0187293;
        double xx = Math.abs(x);
        double y = 1.5707963267948966 - Math.sqrt(1.0 - xx) * (a0 + a1 * xx + a2 * xx * xx + a3 * xx * xx * xx);
        return y * Math.signum(x);
    }

    public static double a_acos(double x) {
        return MathUtils.a_asin(x) * -1.0 + 1.5707963267948966;
    }

    private static double log(double base, double logNumber) {
        return Math.log10(logNumber) / Math.log10(base);
    }

    public static int[] getValidIndexes(Object array, int ... excludedIndexes) {
        try {
            int[] retArray = new int[Array.getLength(array) - excludedIndexes.length];
            int index = 0;
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (Arrays.asList(new int[][]{excludedIndexes}).contains(i)) continue;
                retArray[index] = i;
                ++index;
            }
            return retArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Object reverseArray(Object array) {
        Object[] returnArray = new Object[Array.getLength(array)];
        for (int i = 0; i < Array.getLength(array); ++i) {
            returnArray[Array.getLength((Object)array) - i] = Array.get(array, i);
        }
        return returnArray;
    }

    public static float sobelFilter(float[][] heightmap, int x, int z) {
        float height = heightmap[x][z];
        int maxX = heightmap.length;
        int maxZ = heightmap[0].length;
        float dx = heightmap[x + 1 < maxX ? x + 1 : x - 1][z] - height;
        float dz = heightmap[x][z + 1 < maxZ ? z + 1 : z - 1] - height;
        return (float)Math.sqrt(dx * dx + dz * dz);
    }

    public static float triSobelFilter(float[][][] heightmap, int x, int y, int z) {
        float height = heightmap[x][y][z];
        int maxX = heightmap.length;
        int maxY = heightmap[0].length;
        int maxZ = heightmap[0][0].length;
        float dx = heightmap[x + 1 < maxX ? x + 1 : x - 1][y][z] - height;
        float dy = heightmap[x][y + 1 < maxY ? y + 1 : y - 1][z] - height;
        float dz = heightmap[x][y][z + 1 < maxZ ? z + 1 : z - 1] - height;
        return (float)Math.pow(dx * dx + dy * dy + dz * dz, 0.0);
    }

    public static Vec3 cubeNormalize(Vec3 input) {
        double divisor = 1.0 / Math.max(Math.max(Math.abs(input.f_82479_), Math.abs(input.f_82480_)), Math.abs(input.f_82481_));
        return input.m_82542_(divisor, divisor, divisor);
    }

    public static float ease(float x, EasingType easingType) {
        return easingType.ease(x);
    }

    public static float triLerp(Vector3f pct, float cAAA, float cAAB, float cABA, float cABB, float cBAA, float cBAB, float cBBA, float cBBB) {
        float cAA = Mth.m_14179_((float)pct.m_122239_(), (float)cAAA, (float)cBAA);
        float cAB = Mth.m_14179_((float)pct.m_122239_(), (float)cAAB, (float)cBAB);
        float cBB = Mth.m_14179_((float)pct.m_122239_(), (float)cABB, (float)cBBB);
        float cBA = Mth.m_14179_((float)pct.m_122239_(), (float)cABA, (float)cBBA);
        float cA = Mth.m_14179_((float)pct.m_122269_(), (float)cAA, (float)cBA);
        float cB = Mth.m_14179_((float)pct.m_122269_(), (float)cAB, (float)cBB);
        float c = Mth.m_14179_((float)pct.m_122260_(), (float)cA, (float)cB);
        return c;
    }

    public static double localMinimum(double minX, double maxX, Function<Double, Double> function, double threshold) {
        if (Double.isNaN(threshold)) {
            threshold = 1.0E-10;
        }
        double m = minX;
        double n = maxX;
        double k = (n + m) / 2.0;
        while (n - m > threshold) {
            k = (n + m) / 2.0;
            if (function.apply(k - threshold) < function.apply(k + threshold)) {
                n = k;
                continue;
            }
            m = k;
        }
        return k;
    }

    public static double lerp(double delta, double a, double b) {
        return a + delta * (b - a);
    }

    public static double lerp2(double deltaX, double deltaY, double aa, double ab, double ba, double bb) {
        return MathUtils.lerp(deltaY, MathUtils.lerp(deltaX, aa, ab), MathUtils.lerp(deltaX, ba, bb));
    }

    public static double lerp3(double deltaX, double deltaY, double deltaZ, double aaa, double aba, double baa, double bba, double aab, double abb, double bab, double bbb) {
        return MathUtils.lerp(deltaZ, MathUtils.lerp2(deltaX, deltaY, aaa, aba, baa, bba), MathUtils.lerp2(deltaX, deltaY, aab, abb, bab, bbb));
    }

    public Vector3f getBlackbodyColor(double temperature) {
        float blue;
        float red;
        temperature = Mth.m_14008_((double)temperature, (double)1000.0, (double)40000.0);
        if ((temperature /= 100.0) <= 66.0) {
            red = 255.0f;
        } else {
            red = (float)(329.698727446 * Math.pow(temperature - 60.0, -0.1332047592));
            red = Mth.m_14036_((float)red, (float)0.0f, (float)255.0f);
        }
        float green = temperature <= 66.0 ? (float)(99.4708025861 * Math.log(temperature) - 161.1195681661) : (float)(288.1221695283 * Math.pow(temperature - 60.0, -0.0755148492));
        green = Mth.m_14036_((float)green, (float)0.0f, (float)255.0f);
        if (temperature >= 66.0) {
            blue = 255.0f;
        } else if (temperature <= 19.0) {
            blue = 0.0f;
        } else {
            blue = (float)(138.5177312231 * Math.log(temperature - 10.0) - 305.0447927307);
            blue = Mth.m_14036_((float)blue, (float)0.0f, (float)255.0f);
        }
        return new Vector3f(red, green, blue);
    }

    public static enum WaveType {
        sine,
        square,
        triangle,
        sawtooth;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EasingType implements IEasingFunction
    {
        linear{

            @Override
            public float ease(float x) {
                return x;
            }
        }
        ,
        easeInQuad{

            @Override
            public float ease(float x) {
                return x * x;
            }
        }
        ,
        easeOutQuad{

            @Override
            public float ease(float x) {
                return 1.0f - (1.0f - x) * (1.0f - x);
            }
        }
        ,
        easeInOutQuad{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
            }
        }
        ,
        easeInCubic{

            @Override
            public float ease(float x) {
                return x * x * x;
            }
        }
        ,
        easeOutCubic{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 3.0));
            }
        }
        ,
        easeInOutCubic{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
            }
        }
        ,
        easeInQuart{

            @Override
            public float ease(float x) {
                return x * x * x * x;
            }
        }
        ,
        easeOutQuart{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 4.0));
            }
        }
        ,
        easeInOutQuart{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 8.0f * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
            }
        }
        ,
        easeInQuint{

            @Override
            public float ease(float x) {
                return x * x * x * x * x;
            }
        }
        ,
        easeOutQuint{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.pow(1.0f - x, 5.0));
            }
        }
        ,
        easeInOutQuint{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? 16.0f * x * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
            }
        }
        ,
        easeInSine{

            @Override
            public float ease(float x) {
                return 1.0f - Mth.m_14089_((float)((float)((double)x * Math.PI / 2.0)));
            }
        }
        ,
        easeOutSine{

            @Override
            public float ease(float x) {
                return Mth.m_14031_((float)((float)((double)x * Math.PI / 2.0)));
            }
        }
        ,
        easeInOutSine{

            @Override
            public float ease(float x) {
                return -(Mth.m_14089_((float)((float)(Math.PI * (double)x))) - 1.0f) / 2.0f;
            }
        }
        ,
        easeInExpo{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f);
            }
        }
        ,
        easeOutExpo{

            @Override
            public float ease(float x) {
                return x == 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * x));
            }
        }
        ,
        easeInOutExpo{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0));
            }
        }
        ,
        easeInCirc{

            @Override
            public float ease(float x) {
                return (float)(1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));
            }
        }
        ,
        easeOutCirc{

            @Override
            public float ease(float x) {
                return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
            }
        }
        ,
        easeInOutCirc{

            @Override
            public float ease(float x) {
                return (float)((double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0);
            }
        }
        ,
        easeInBack{

            @Override
            public float ease(float x) {
                return 2.70158f * x * x * x - 1.70158f * x * x;
            }
        }
        ,
        easeOutBack{

            @Override
            public float ease(float x) {
                return (float)(1.0 + (double)2.70158f * Math.pow(x - 1.0f, 3.0) + (double)1.70158f * Math.pow(x - 1.0f, 2.0));
            }
        }
        ,
        easeInOutBack{

            @Override
            public float ease(float x) {
                return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * (double)(7.189819f * x - 2.5949094f) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * (double)(3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0) / 2.0);
            }
        }
        ,
        easeInElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * (double)Mth.m_14031_((float)((float)(((double)(x * 10.0f) - 10.75) * 2.0943951023931953))));
            }
        }
        ,
        easeOutElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * (double)Mth.m_14031_((float)((float)(((double)(x * 10.0f) - 0.75) * 2.0943951023931953))) + 1.0);
            }
        }
        ,
        easeInOutElastic{

            @Override
            public float ease(float x) {
                return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * (double)Mth.m_14031_((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636)))) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * (double)Mth.m_14031_((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636))) / 2.0 + 1.0));
            }
        }
        ,
        easeInBounce{

            @Override
            public float ease(float x) {
                return 1.0f - EasingType.bounceOut(1.0f - x);
            }
        }
        ,
        easeOutBounce{

            @Override
            public float ease(float x) {
                return 1.0f - EasingType.bounceOut(1.0f - x);
            }
        }
        ,
        easeInOutBounce{

            @Override
            public float ease(float x) {
                return (double)x < 0.5 ? (1.0f - EasingType.bounceOut(1.0f - 2.0f * x)) / 2.0f : (1.0f + EasingType.bounceOut(2.0f * x - 1.0f)) / 2.0f;
            }
        };


        private static float bounceOut(float x) {
            float n1 = 7.5625f;
            float d1 = 2.75f;
            if (x < 1.0f / d1) {
                return n1 * x * x;
            }
            if (x < 2.0f / d1) {
                x = (float)((double)x - 1.5 / (double)d1);
                return n1 * x * x + 0.75f;
            }
            if ((double)x < 2.5 / (double)d1) {
                x = (float)((double)x - 2.25 / (double)d1);
                return n1 * x * x + 0.9375f;
            }
            x = (float)((double)x - 2.625 / (double)d1);
            return n1 * x * x + 0.984375f;
        }
    }

    public static interface IEasingFunction {
        public float ease(float var1);
    }
}

