/*
 * Decompiled with CFR 0.152.
 */
package com.github.dimadencep.mods.rrls.mixins;

import com.github.dimadencep.mods.rrls.Rrls;
import com.github.dimadencep.mods.rrls.accessor.SplashAccessor;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    public abstract ToastComponent m_91300_();

    @Shadow
    protected abstract CompletableFuture<Void> m_168019_(boolean var1);

    @Inject(method={"onResourceReloadFailure"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResourceReloadFailure(Throwable exception, Component resourceName, CallbackInfo ci) {
        if (!Rrls.config.resetResources) {
            Rrls.logger.error("Caught error loading resourcepacks!", exception);
            this.m_168019_(true).thenRun(() -> SystemToast.m_94869_((ToastComponent)this.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)Component.m_237115_((String)"resourcePack.load_fail"), (Component)resourceName));
            ci.cancel();
        }
    }

    @Redirect(method={"tick", "handleInputEvents"}, at=@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;overlay:Lnet/minecraft/client/gui/screen/Overlay;"))
    public Overlay fixOverlayUsage(Minecraft instance) {
        return Rrls.tryGetOverlay(instance.f_91081_);
    }

    @Inject(method={"getOverlay"}, at={@At(value="HEAD")})
    public void getOverlay(CallbackInfoReturnable<Overlay> cir) {
        SplashAccessor accessor;
        Object object = cir.getReturnValue();
        if (object instanceof SplashAccessor && (accessor = (SplashAccessor)object).isAttached()) {
            Class<?> callerClass = Rrls.classWalker.getCallerClass();
            Rrls.logger.warn("Illegal getOverlay access: {}", (Object)callerClass.getName());
        }
    }
}

