/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import fuffles.tactical_fishing.GsonUtil;
import fuffles.tactical_fishing.TacticalFishing;
import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import fuffles.tactical_fishing.lib.ItemTags;
import fuffles.tactical_fishing.lib.RecipeSerializers;
import fuffles.tactical_fishing.lib.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class DatapackWriter {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private static File makeDir(File parent, String child) {
        File dir = new File(parent, child);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    private static File constructPath(File from, String ... paths) {
        File last = from;
        for (String str : paths) {
            last = DatapackWriter.makeDir(last, str);
        }
        return last;
    }

    private static void writePackMcMeta(File in, int version, String desc) {
        File mcmeta = new File(in, "pack.mcmeta");
        try (JsonWriter writer = GSON.newJsonWriter((Writer)Files.newWriter((File)mcmeta, (Charset)StandardCharsets.UTF_8));){
            GSON.toJson((JsonElement)GsonUtil.newObject(obj -> obj.add("pack", (JsonElement)GsonUtil.newObject(pack -> {
                pack.addProperty("pack_format", (Number)version);
                pack.addProperty("description", desc);
                pack.add("mods", (JsonElement)GsonUtil.newArray(mods -> {
                    for (ModInfo info : FMLLoader.getLoadingModList().getMods()) {
                        mods.add(info.getModId());
                    }
                }));
            }))), writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeTag(File in, List<ResourceLocation> rods) {
        File tag = new File(in, Resources.TAG_FISHING_RODS.m_135815_() + ".json");
        try (JsonWriter writer = GSON.newJsonWriter((Writer)Files.newWriter((File)tag, (Charset)StandardCharsets.UTF_8));){
            GSON.toJson((JsonElement)GsonUtil.newObject(obj -> {
                obj.addProperty("replace", Boolean.valueOf(false));
                obj.add("values", (JsonElement)GsonUtil.newArray(values -> {
                    if (!rods.isEmpty()) {
                        for (ResourceLocation rod : rods) {
                            values.add(rod.toString());
                        }
                    }
                }));
            }), writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static List<Recipe<?>> write(File to, String key, int version, String desc) {
        DatapackWriter.writePackMcMeta(to, version, desc);
        File recipePath = DatapackWriter.constructPath(to, "data", key, "recipes", "inbuilt");
        File tagsPath = DatapackWriter.constructPath(to, "data", key, "tags", "items");
        ArrayList<ResourceLocation> rods = new ArrayList<ResourceLocation>();
        ArrayList recipes = new ArrayList();
        for (ResourceLocation registryKey : ForgeRegistries.ITEMS.getKeys()) {
            if (ForgeRegistries.ITEMS.getValue(registryKey) instanceof FishingRodItem) {
                rods.add(registryKey);
                continue;
            }
            if (!((Boolean)TacticalFishing.Config.COMMON.writeFishBucketRecipes.get()).booleanValue() || !registryKey.m_135815_().endsWith("_bucket")) continue;
            String id = registryKey.m_135827_();
            ResourceLocation potentialFish = new ResourceLocation(id, registryKey.m_135815_().substring(0, registryKey.m_135815_().lastIndexOf("_")));
            ResourceLocation potentialRawFish = new ResourceLocation(id, "raw_" + potentialFish.m_135815_());
            Optional<Item> fish = Optional.of((Item)ForgeRegistries.ITEMS.getValue(potentialFish)).or(() -> Optional.of((Item)ForgeRegistries.ITEMS.getValue(potentialRawFish)));
            if (!fish.isPresent()) continue;
            FishingRecipe recipe = new FishingRecipe(new ResourceLocation("tactical_fishing", "fishing_" + registryKey.toString().replace(':', '_')), Resources.RECIPE_GROUP_FISH_BUCKETS.toString(), Ingredient.m_204132_(ItemTags.RODS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{fish.get().m_7968_()}), ((Item)ForgeRegistries.ITEMS.getValue(registryKey)).m_7968_());
            File recipeOut = new File(recipePath, recipe.m_6423_().m_135815_());
            if (recipeOut.exists()) {
                TacticalFishing.LOG.info("Skipping recipe 'inbuilt/" + recipe.m_6423_().m_135815_() + ".json' as it already exists.");
                continue;
            }
            try {
                JsonWriter writer = GSON.newJsonWriter((Writer)Files.newWriter((File)recipeOut, (Charset)StandardCharsets.UTF_8));
                try {
                    GSON.toJson((JsonElement)GsonUtil.newObject(obj -> {
                        obj.addProperty("type", Resources.RECIPE_SERIALIZER_FISHING.toString());
                        RecipeSerializers.FISHING.toJson((JsonObject)obj, recipe);
                    }), writer);
                    recipes.add(recipe);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DatapackWriter.writeTag(tagsPath, rods);
        return recipes;
    }

    private static List<String> getPackMcMetaModList(File in) {
        ArrayList<String> modList = new ArrayList<String>();
        File mcmeta = new File(in, "pack.mcmeta");
        if (mcmeta.exists()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            try (BufferedReader reader = Files.newReader((File)mcmeta, (Charset)StandardCharsets.UTF_8);){
                JsonObject pack;
                Object object;
                JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (obj.has("pack") && (object = obj.get("pack")) instanceof JsonObject && (pack = (JsonObject)object).has("last_mods") && (object = pack.get("last_mods")) instanceof JsonArray) {
                    JsonArray mods = (JsonArray)object;
                    for (JsonElement mod : mods) {
                        if (mod.isJsonNull() || !mod.isJsonPrimitive()) continue;
                        modList.add(mod.getAsString());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            TacticalFishing.LOG.warn("Couldn't find pack.mcmeta file in '" + in.toString() + "', can't verify mod integrity!");
        }
        return modList;
    }

    @Deprecated
    public static boolean isPackOutdated(File in) {
        List<String> modList = DatapackWriter.getPackMcMetaModList(in);
        if (!modList.isEmpty()) {
            for (ModInfo info : FMLLoader.getLoadingModList().getMods()) {
                if (modList.contains(info.getModId())) continue;
                return true;
            }
        }
        return false;
    }
}

