/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing;

import com.mojang.logging.LogUtils;
import fuffles.tactical_fishing.Proxy;
import fuffles.tactical_fishing.common.Registry;
import fuffles.tactical_fishing.common.entity.FishingVisual;
import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import fuffles.tactical_fishing.lib.RecipeTypes;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="tactical_fishing")
public class TacticalFishing
implements Proxy {
    public static final String ID = "tactical_fishing";
    public static final Logger LOG = LogUtils.getLogger();

    public static void DEBUG(String str) {
        if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
            LOG.debug(str);
        }
    }

    public static boolean DEBUG(boolean bool, String str) {
        TacticalFishing.DEBUG(str);
        return bool;
    }

    public TacticalFishing() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC, "tactical_fishing.toml");
        this.init();
    }

    @Override
    public void init() {
        this.getFMLBus().register(Registry.class);
        this.getForgeBus().addListener(this::onItemFished);
    }

    private Optional<FishingRecipe> tryMatch(FishingRecipe recipe, ServerPlayer player, NonNullList<ItemStack> fish) {
        return recipe.matches("INITIAL", player.m_150109_(), fish) ? Optional.of(recipe) : Optional.empty();
    }

    private Optional<FishingRecipe> getFishingRecipe(ServerPlayer player, NonNullList<ItemStack> fish) {
        return player.m_20194_().m_129894_().m_44054_(RecipeTypes.FISHING).values().stream().flatMap(recipe -> this.tryMatch((FishingRecipe)recipe, player, fish).stream()).findFirst();
    }

    public void onItemFished(ItemFishedEvent event) {
        ServerPlayer sPlayer;
        Optional<FishingRecipe> matches;
        Player player = event.getEntity();
        if (player != null && !player.f_19853_.f_46443_ && !event.isCanceled() && (matches = this.getFishingRecipe(sPlayer = (ServerPlayer)player, (NonNullList<ItemStack>)event.getDrops())).isPresent()) {
            FishingRecipe recipe = matches.get();
            FishingHook hook = event.getHookEntity();
            for (ItemStack fish : event.getDrops()) {
                if (!recipe.getCatch().test(fish)) continue;
                ItemEntity visual = new ItemEntity(hook.f_19853_, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), fish);
                double dx = player.m_20185_() - hook.m_20185_();
                double dy = player.m_20186_() - hook.m_20186_();
                double dz = player.m_20189_() - hook.m_20189_();
                double vel = 0.1;
                visual.m_20334_(dx * vel, dy * vel + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.08, dz * 0.1);
                if (visual instanceof FishingVisual) {
                    FishingVisual fv = (FishingVisual)visual;
                    fv.setFishingRecipe(recipe);
                }
                hook.f_19853_.m_7967_((Entity)visual);
                break;
            }
            event.setCanceled(true);
        }
    }

    public static class Config {
        private static final ForgeConfigSpec COMMON_SPEC;
        public static final Common COMMON;

        private static ForgeConfigSpec.BooleanValue build(ForgeConfigSpec.Builder builder, String key, boolean def, String ... comments) {
            return builder.comment(comments).define(key, def);
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
            COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
            COMMON = (Common)specPair.getLeft();
        }

        public static class Common {
            public final ForgeConfigSpec.BooleanValue debug;
            public final ForgeConfigSpec.BooleanValue writeDatapack;
            public final ForgeConfigSpec.BooleanValue writeFishBucketRecipes;

            private Common(ForgeConfigSpec.Builder builder) {
                builder.push("general");
                this.debug = Config.build(builder, "Debug", false, "When true writes a step-by-step feedback to your log file when the mod is testing if a certain combination matches a recipe's requirement; Default: false");
                this.writeDatapack = Config.build(builder, "WriteDatapack", true, "When true writes the in-built data for this mod; Default: true", "Keep in mind if you set this to false there will be no 'tactical_fishing:fishing_rods' tag nor any of the fish bucket recipes");
                builder.pop();
                builder.push("datapack");
                this.writeFishBucketRecipes = Config.build(builder, "WriteFishBucketRecipes", true, "When true writes recipes for each possible fish bucket; Default: true", "If you want to use this mod for the fishing crafting without the fish buckets, you should set this to false");
                builder.pop();
            }
        }
    }
}

