/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.common.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuffles.tactical_fishing.GsonUtil;
import fuffles.tactical_fishing.TacticalFishing;
import fuffles.tactical_fishing.lib.RecipeSerializers;
import fuffles.tactical_fishing.lib.RecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class FishingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient rod;
    private final Ingredient ingredient;
    private final Ingredient fish;
    private final ItemStack output;
    private NonNullList<Ingredient> serialized_ingredients;

    public FishingRecipe(ResourceLocation id, String group, Ingredient rod, Ingredient ingredient, Ingredient fish, ItemStack output) {
        this.id = id;
        this.group = group;
        this.rod = rod;
        this.ingredient = ingredient;
        this.fish = fish;
        this.output = output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    @Deprecated
    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(String debugPhase, Inventory playerInv, NonNullList<ItemStack> fish) {
        boolean result;
        ItemStack rod;
        ItemStack main = playerInv.m_36056_();
        ItemStack off = (ItemStack)playerInv.f_35976_.get(0);
        TacticalFishing.DEBUG("[" + this.m_6423_() + "] [ + " + debugPhase + " + ] Pushing test match -> [" + main + ", " + off + "] + " + fish);
        if (main.m_41619_() && off.m_41619_()) {
            return TacticalFishing.DEBUG(false, "[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! Both hands empty.");
        }
        if (main.m_41619_() || off.m_41619_()) {
            return TacticalFishing.DEBUG(false, "[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! One of the hands is empty.");
        }
        Object object = main.m_41720_() instanceof FishingRodItem ? main : (rod = off.m_41720_() instanceof FishingRodItem ? off : null);
        if (rod == null) {
            return TacticalFishing.DEBUG(false, "[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! No fishing rod present.");
        }
        ItemStack other = ItemStack.m_41728_((ItemStack)rod, (ItemStack)main) ? off : main;
        boolean bl = result = this.rod.test(rod) && this.ingredient.test(other) && fish.stream().anyMatch(this.fish);
        if (result) {
            TacticalFishing.DEBUG("[" + this.m_6423_() + "] [ + " + debugPhase + " + ] success!");
        } else {
            if (!this.rod.test(rod)) {
                TacticalFishing.DEBUG("[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! Rod does not match [" + Lists.newArrayList((Object[])this.rod.m_43908_()) + "]");
            }
            if (!this.ingredient.test(other)) {
                TacticalFishing.DEBUG("[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! Other hand item does not match [" + Lists.newArrayList((Object[])this.ingredient.m_43908_()) + "]");
            } else {
                TacticalFishing.DEBUG("[" + this.m_6423_() + "] [ + " + debugPhase + " + ] failure! Catch does not match [" + Lists.newArrayList((Object[])this.fish.m_43908_()) + "]");
            }
        }
        return result;
    }

    public ItemStack m_5874_(Container container) {
        return this.m_8043_().m_41777_();
    }

    @Deprecated
    public boolean m_8004_(int x, int y) {
        return true;
    }

    public Ingredient getRod() {
        return this.rod;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getCatch() {
        return this.fish;
    }

    public NonNullList<Ingredient> m_7527_() {
        if (this.serialized_ingredients == null) {
            this.serialized_ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.rod, this.ingredient, this.fish});
        }
        return this.serialized_ingredients;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ItemStack m_8042_() {
        return Items.f_42523_.m_7968_();
    }

    public RecipeSerializer<FishingRecipe> m_7707_() {
        return RecipeSerializers.FISHING;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.FISHING;
    }

    public static class Serializer
    implements RecipeSerializer<FishingRecipe> {
        public FishingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient rod = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"rod"));
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            Ingredient fish = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catch"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new FishingRecipe(id, group, rod, ingredient, fish, result);
        }

        public void toJson(JsonObject json, FishingRecipe recipe) {
            if (recipe.m_6076_() != null && !recipe.m_6076_().isBlank()) {
                json.addProperty("group", recipe.m_6076_());
            }
            json.add("rod", recipe.getRod().m_43942_());
            json.add("ingredient", recipe.getIngredient().m_43942_());
            json.add("catch", recipe.getCatch().m_43942_());
            ResourceLocation result = ForgeRegistries.ITEMS.getKey((Object)recipe.output.m_41720_());
            json.add("result", (JsonElement)GsonUtil.newObject(obj -> obj.addProperty("item", result.toString())));
            json.add("conditions", (JsonElement)GsonUtil.newArray(array -> array.add((JsonElement)GsonUtil.newObject(obj -> {
                obj.addProperty("type", ModLoadedCondition.Serializer.INSTANCE.getID().toString());
                obj.addProperty("modid", result.m_135827_());
            }))));
        }

        public FishingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            Ingredient rod = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient fish = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new FishingRecipe(id, group, rod, ingredient, fish, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, FishingRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            recipe.rod.m_43923_(buffer);
            recipe.ingredient.m_43923_(buffer);
            recipe.fish.m_43923_(buffer);
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

