/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.mixin;

import fuffles.tactical_fishing.common.entity.FishingVisual;
import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import fuffles.tactical_fishing.lib.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements FishingVisual {
    private FishingRecipe fishingRecipe = null;

    private ItemEntityMixin(EntityType<?> arg, Level arg2) {
        super(arg, arg2);
    }

    @Shadow
    public ItemStack m_32055_() {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean isFishingVisual() {
        return this.fishingRecipe != null;
    }

    @Override
    public void setFishingRecipe(FishingRecipe recipe) {
        this.fishingRecipe = recipe;
    }

    @Override
    public FishingRecipe getFishingRecipe() {
        return this.fishingRecipe;
    }

    @Inject(method={"isMergable()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isMergable(CallbackInfoReturnable<Boolean> cbr) {
        if (this.isFishingVisual()) {
            cbr.setReturnValue((Object)false);
        }
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerTouch(Player player, CallbackInfo cb) {
        if (!this.f_19853_.f_46443_ && this.isFishingVisual()) {
            FishingRecipe recipe = this.getFishingRecipe();
            if (recipe.matches("VERIFY", player.m_150109_(), (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{this.m_32055_()}))) {
                InteractionHand targetHand = recipe.getIngredient().test(player.m_21120_(InteractionHand.MAIN_HAND)) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_21008_(targetHand, recipe.m_5874_(null));
                player.m_21011_(targetHand, true);
                player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), SoundEvents.f_11917_, player.m_5720_(), 0.8f, 0.8f + player.f_19853_.f_46441_.m_188501_() * 0.4f, false);
                player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, this.f_19796_.m_188503_(6) + 1));
                CriteriaTriggers.FISHING_CRAFTING.trigger((ServerPlayer)player, recipe);
                this.m_146870_();
                cb.cancel();
            } else {
                this.setFishingRecipe(null);
            }
        }
    }
}

