/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.handcrafted.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import earth.terrarium.handcrafted.client.block.table.table.TableModel;
import earth.terrarium.handcrafted.common.block.property.SheetState;
import earth.terrarium.handcrafted.common.block.property.TableState;
import earth.terrarium.handcrafted.common.block.table.table.TableBlock;
import earth.terrarium.handcrafted.common.block.table.table.TableBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;

public class OptimizedTableRenderer
implements BlockEntityRenderer<TableBlockEntity> {
    public static final Map<Item, Material> OBJECT_TO_TEXTURE = new Object2ObjectArrayMap();
    public static OptimizedTableRenderer INSTANCE = null;
    private final TableModel model;
    private final ModelPart northeastLeg;
    private final ModelPart northwestLeg;
    private final ModelPart southeastLeg;
    private final ModelPart northOverlay;
    private final ModelPart southwestLeg;
    private final ModelPart eastOverlay;
    private final ModelPart southOverlay;
    private final ModelPart westOverlay;

    public OptimizedTableRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new TableModel(ctx.m_173585_().m_171103_(TableModel.LAYER_LOCATION));
        this.northeastLeg = this.model.getMain().m_171324_("table").m_171324_("northeast_leg");
        this.northwestLeg = this.model.getMain().m_171324_("table").m_171324_("northwest_leg");
        this.southeastLeg = this.model.getMain().m_171324_("table").m_171324_("southeast_leg");
        this.southwestLeg = this.model.getMain().m_171324_("table").m_171324_("southwest_leg");
        this.northOverlay = this.model.getMain().m_171324_("overlay").m_171324_("overlay_side_north");
        this.eastOverlay = this.model.getMain().m_171324_("overlay").m_171324_("overlay_side_east");
        this.southOverlay = this.model.getMain().m_171324_("overlay").m_171324_("overlay_side_south");
        this.westOverlay = this.model.getMain().m_171324_("overlay").m_171324_("overlay_side_west");
        INSTANCE = this;
    }

    public void render(TableBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        TableState tableState = (TableState)entity.m_58900_().m_61143_((Property)TableBlock.TABLE_BLOCK_SHAPE);
        SheetState sheetState = (SheetState)entity.m_58900_().m_61143_((Property)TableBlock.TABLE_SHEET_SHAPE);
        Item b = entity.m_58900_().m_60734_().m_5456_();
        Item sheet = entity.getStack().m_41720_();
        this.doRender(poseStack, buffer, packedLight, packedOverlay, tableState, sheetState, sheet, b);
    }

    public void doRender(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, TableState tableState, SheetState sheetState, Item sheet, Item block) {
        Material sheetTexture;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        switch (tableState) {
            case SINGLE: {
                this.northeastLeg.f_104207_ = true;
                this.northwestLeg.f_104207_ = true;
                this.southeastLeg.f_104207_ = true;
                this.southwestLeg.f_104207_ = true;
                break;
            }
            case CENTER: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = false;
                break;
            }
            case NORTH_EAST_CORNER: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = true;
                break;
            }
            case NORTH_WEST_CORNER: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = true;
                break;
            }
            case SOUTH_EAST_CORNER: {
                this.northeastLeg.f_104207_ = true;
                this.northwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = false;
                break;
            }
            case SOUTH_WEST_CORNER: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = true;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = false;
                break;
            }
            case NORTH_SIDE: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = true;
                this.southwestLeg.f_104207_ = true;
                break;
            }
            case EAST_SIDE: {
                this.northeastLeg.f_104207_ = true;
                this.northwestLeg.f_104207_ = false;
                this.southeastLeg.f_104207_ = true;
                this.southwestLeg.f_104207_ = false;
                break;
            }
            case SOUTH_SIDE: {
                this.northeastLeg.f_104207_ = true;
                this.northwestLeg.f_104207_ = true;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = false;
                break;
            }
            case WEST_SIDE: {
                this.northeastLeg.f_104207_ = false;
                this.northwestLeg.f_104207_ = true;
                this.southeastLeg.f_104207_ = false;
                this.southwestLeg.f_104207_ = true;
            }
        }
        switch (sheetState) {
            case SINGLE: {
                this.northOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = true;
                break;
            }
            case CENTER: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case NORTH_SIDE: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case EAST_SIDE: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = true;
                break;
            }
            case SOUTH_SIDE: {
                this.northOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case WEST_SIDE: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case NORTH_EAST_CORNER: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = true;
                break;
            }
            case NORTH_WEST_CORNER: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case SOUTH_EAST_CORNER: {
                this.northOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = false;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = true;
                break;
            }
            case SOUTH_WEST_CORNER: {
                this.northOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = false;
                this.westOverlay.f_104207_ = false;
                break;
            }
            case NORTH_COVER: {
                this.northOverlay.f_104207_ = false;
                this.eastOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = true;
                break;
            }
            case EAST_COVER: {
                this.eastOverlay.f_104207_ = false;
                this.northOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = true;
                break;
            }
            case SOUTH_COVER: {
                this.southOverlay.f_104207_ = false;
                this.northOverlay.f_104207_ = true;
                this.westOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = true;
                break;
            }
            case WEST_COVER: {
                this.westOverlay.f_104207_ = false;
                this.northOverlay.f_104207_ = true;
                this.southOverlay.f_104207_ = true;
                this.eastOverlay.f_104207_ = true;
            }
        }
        Material texture = OBJECT_TO_TEXTURE.get(block);
        this.model.m_7695_(poseStack, texture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (sheet != Items.f_41852_ && (sheetTexture = OBJECT_TO_TEXTURE.get(sheet)) != null) {
            this.model.m_7695_(poseStack, sheetTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

