/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infernalstudios.miningmaster.client.gui.screen.inventory.GemForgeScreen;
import org.infernalstudios.miningmaster.enchantments.GraceEnchantment;
import org.infernalstudios.miningmaster.enchantments.HeartfeltEnchantment;
import org.infernalstudios.miningmaster.enchantments.KnightJumpEnchantment;
import org.infernalstudios.miningmaster.enchantments.RunnerEnchantment;
import org.infernalstudios.miningmaster.enchantments.SnowpiercerEnchantment;
import org.infernalstudios.miningmaster.events.MiningMasterClientEvents;
import org.infernalstudios.miningmaster.events.MiningMasterEvents;
import org.infernalstudios.miningmaster.init.MMBlocks;
import org.infernalstudios.miningmaster.init.MMContainerTypes;
import org.infernalstudios.miningmaster.init.MMEnchantments;
import org.infernalstudios.miningmaster.init.MMFeatures;
import org.infernalstudios.miningmaster.init.MMItems;
import org.infernalstudios.miningmaster.init.MMLootModifiers;
import org.infernalstudios.miningmaster.init.MMRecipes;
import org.infernalstudios.miningmaster.init.MMSounds;
import org.infernalstudios.miningmaster.init.MMTileEntityTypes;
import org.infernalstudios.miningmaster.network.MMNetworkHandler;

@Mod(value="miningmaster")
public class MiningMaster {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "miningmaster";
    public static final CreativeModeTab TAB = new CreativeModeTab("MiningMasterTab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)MMItems.TAB_ITEM.get());
        }
    };

    public MiningMaster() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MMBlocks.register(modEventBus);
        MMItems.register(modEventBus);
        MMEnchantments.register(modEventBus);
        MMRecipes.register(modEventBus);
        MMContainerTypes.register(modEventBus);
        MMTileEntityTypes.register(modEventBus);
        MMSounds.register(modEventBus);
        MMLootModifiers.register(modEventBus);
        MMFeatures.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)new MiningMasterEvents());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new MiningMasterClientEvents()));
        MinecraftForge.EVENT_BUS.addListener(RunnerEnchantment::onItemAttributeModifierCalculate);
        MinecraftForge.EVENT_BUS.addListener(RunnerEnchantment::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(HeartfeltEnchantment::onItemAttributeModifierCalculate);
        MinecraftForge.EVENT_BUS.addListener(HeartfeltEnchantment::onItemUnequip);
        MinecraftForge.EVENT_BUS.addListener(HeartfeltEnchantment::onLivingDamage);
        MinecraftForge.EVENT_BUS.addListener(SnowpiercerEnchantment::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(GraceEnchantment::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(KnightJumpEnchantment::onClientTick);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(MMNetworkHandler::register);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)MMItems.AIR_MALACHITE_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity, entityId) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)MMItems.AIR_MALACHITE_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity, entityId) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            MenuScreens.m_96206_((MenuType)((MenuType)MMContainerTypes.GEM_FORGE_CONTAINER.get()), GemForgeScreen::new);
        });
    }
}

