/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.miningmaster.client.gui.recipebook.GemForgeRecipeGui;
import org.infernalstudios.miningmaster.containers.GemForgeContainer;
import org.infernalstudios.miningmaster.network.MMNetworkHandler;
import org.infernalstudios.miningmaster.network.UpdateGemForgePacket;

@OnlyIn(value=Dist.CLIENT)
public class GemForgeScreen
extends AbstractContainerScreen<GemForgeContainer>
implements RecipeUpdateListener {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("miningmaster", "textures/gui/container/gem_forge.png");
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("miningmaster", "textures/gui/recipe_button.png");
    private boolean widthTooNarrowIn;
    public final RecipeBookComponent recipeGui = new GemForgeRecipeGui();

    public GemForgeScreen(GemForgeContainer screenContainer, Inventory inv, Component name) {
        super((AbstractContainerMenu)screenContainer, inv, name);
    }

    public void m_7856_() {
        super.m_7856_();
        this.widthTooNarrowIn = this.f_96543_ < 379;
        this.recipeGui.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrowIn, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeGui.m_181401_(this.f_96543_, this.f_97726_);
        this.m_142416_((GuiEventListener)new ConfirmButton(142, 33, this));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 15, this.f_96544_ / 2 - 49, 20, 18, 0, 0, 19, BUTTON_TEXTURE, button -> {
            this.recipeGui.m_181404_();
            this.recipeGui.m_100384_();
            this.f_97735_ = this.recipeGui.m_181401_(this.f_96543_, this.f_97726_);
            ((ImageButton)button).m_94278_(this.f_97735_ + 15, this.f_96544_ / 2 - 49);
        }));
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    public void m_181908_() {
        this.recipeGui.m_100386_();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        if (this.recipeGui.m_100385_() && this.widthTooNarrowIn) {
            this.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
            this.recipeGui.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            this.recipeGui.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.recipeGui.m_6545_(matrixStack, this.f_97735_, this.f_97736_, true, partialTicks);
        }
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.recipeGui.m_100361_(matrixStack, this.f_97735_, this.f_97736_, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (((GemForgeContainer)this.f_97732_).isForgeActive()) {
            int k = ((GemForgeContainer)this.f_97732_).getForgeTimeScaled();
            this.m_93228_(matrixStack, i + 60 + k, Math.min(j + 33 + k, j + 49), 176 + k, Math.min(k, 16), 56 - 2 * k, Math.max(36 - 2 * k, 3));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.recipeGui.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.widthTooNarrowIn && this.recipeGui.m_100385_() || super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.m_6597_(slotIn, slotId, mouseButton, type);
        this.recipeGui.m_6904_(slotIn);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return !this.recipeGui.m_7933_(keyCode, scanCode, modifiers) && super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.f_97726_) || mouseY >= (double)(guiTopIn + this.f_97727_);
        return this.recipeGui.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, mouseButton) && flag;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.recipeGui.m_5534_(codePoint, modifiers) || super.m_5534_(codePoint, modifiers);
    }

    public void m_6916_() {
        this.recipeGui.m_100387_();
    }

    public RecipeBookComponent m_5564_() {
        return this.recipeGui;
    }

    public void m_7861_() {
        this.recipeGui.m_100373_();
        super.m_7861_();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ConfirmButton
    extends Button {
        public ConfirmButton(int x, int y, GemForgeScreen screen) {
            super(x, y, screen);
        }

        @Override
        protected void renderIcon(PoseStack p_230454_1_) {
        }

        public void m_5691_() {
            if (((GemForgeContainer)GemForgeScreen.this.f_97732_).isRecipeValid()) {
                MMNetworkHandler.sendToServer(new UpdateGemForgePacket(true));
            }
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class Button
    extends AbstractButton {
        private final GemForgeScreen screen;
        private final int xOffset;
        private final int yOffset;

        protected Button(int x, int y, GemForgeScreen screen) {
            super(x, y, 20, 20, (Component)Component.m_237119_());
            this.screen = screen;
            this.xOffset = x;
            this.yOffset = y;
            this.f_93620_ = this.xOffset + this.screen.f_97735_;
            this.f_93621_ = this.yOffset + this.screen.f_97736_;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
            int i = 165;
            int j = 0;
            if (((GemForgeContainer)this.screen.f_97732_).isForgeActive()) {
                j += this.f_93618_;
            } else if (!((GemForgeContainer)this.screen.f_97732_).isRecipeValid()) {
                j += this.f_93618_ * 2;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            this.f_93620_ = this.xOffset + this.screen.f_97735_;
            this.f_93621_ = this.yOffset + this.screen.f_97736_;
            this.f_93623_ = ((GemForgeContainer)this.screen.f_97732_).isRecipeValid() && !((GemForgeContainer)this.screen.f_97732_).isForgeActive();
            this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, j, i, this.f_93618_, this.f_93619_);
            this.screen.f_96542_.m_115123_(new ItemStack((ItemLike)Items.f_42448_), this.f_93620_ + 2, this.f_93621_ + 2);
            this.renderIcon(matrixStack);
        }

        protected abstract void renderIcon(PoseStack var1);
    }
}

