/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.client.integration.jei;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.infernalstudios.miningmaster.init.MMBlocks;
import org.infernalstudios.miningmaster.recipes.ForgingRecipe;

public class GemForgeRecipeCategory
implements IRecipeCategory<ForgingRecipe> {
    public static final RecipeType<ForgingRecipe> RECIPE_TYPE = RecipeType.create((String)"miningmaster", (String)ForgingRecipe.TYPE_ID.m_135815_(), ForgingRecipe.class);
    private static final String TITLE_TRANSLATION_KEY = "miningmaster.jei.forging";
    private final Component titleTextComponent = Component.m_237115_((String)"miningmaster.jei.forging");
    private final IDrawable background;
    private final IDrawable icon;
    private static final Pair<Integer, Integer>[] SLOTS = new Pair[]{Pair.of((Object)1, (Object)37), Pair.of((Object)1, (Object)19), Pair.of((Object)1, (Object)1), Pair.of((Object)19, (Object)1), Pair.of((Object)37, (Object)1), Pair.of((Object)55, (Object)1), Pair.of((Object)73, (Object)1), Pair.of((Object)73, (Object)19), Pair.of((Object)73, (Object)37), Pair.of((Object)37, (Object)27), Pair.of((Object)130, (Object)19)};

    public GemForgeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("miningmaster", "textures/gui/container/gem_forge.png"), 0, 185, 151, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((Block)MMBlocks.GEM_FORGE.get()).m_5456_()));
    }

    public RecipeType<ForgingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.titleTextComponent;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ForgingRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        Ingredient catalyst = (Ingredient)recipeIngredients.remove(recipeIngredients.size() - 1);
        ItemStack output = recipe.getDefaultedOutput();
        for (int i = 0; i < Math.min(recipeIngredients.size(), 9); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)SLOTS[i].getFirst()).intValue(), ((Integer)SLOTS[i].getSecond()).intValue()).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(i)).m_43908_()));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, ((Integer)SLOTS[9].getFirst()).intValue(), ((Integer)SLOTS[9].getSecond()).intValue()).addItemStacks(Arrays.asList(catalyst.m_43908_()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)SLOTS[10].getFirst()).intValue(), ((Integer)SLOTS[10].getSecond()).intValue()).addItemStack(output);
    }
}

