/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.client.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.infernalstudios.miningmaster.client.integration.jei.GemForgeRecipeCategory;
import org.infernalstudios.miningmaster.init.MMBlocks;
import org.infernalstudios.miningmaster.init.MMRecipes;

@JeiPlugin
public class MiningMasterJEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("miningmaster", "jei_main");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new GemForgeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Collection recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44051_();
        List gemForgingRecipes = (List)recipes.stream().filter(recipe -> recipe.m_6671_() == MMRecipes.FORGING_RECIPE_TYPE).collect(ImmutableList.toImmutableList());
        registration.addRecipes(GemForgeRecipeCategory.RECIPE_TYPE, gemForgingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)MMBlocks.GEM_FORGE.get()).m_5456_()), new RecipeType[]{GemForgeRecipeCategory.RECIPE_TYPE});
    }
}

