/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.containers;

import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.infernalstudios.miningmaster.init.MMContainerTypes;
import org.infernalstudios.miningmaster.recipes.GemForgeServerRecipePlacer;

public class GemForgeContainer
extends RecipeBookMenu<Container> {
    private final ItemStackHandler forgeInventory;
    protected final Level world;
    public ContainerData forgeData;

    public GemForgeContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, new ItemStackHandler(10), (ContainerData)new SimpleContainerData(4));
    }

    public GemForgeContainer(int id, Inventory playerInventory, ItemStackHandler inventory, ContainerData forgeData) {
        super((MenuType)MMContainerTypes.GEM_FORGE_CONTAINER.get(), id);
        this.forgeData = forgeData;
        this.forgeInventory = inventory;
        this.world = playerInventory.f_35978_.f_19853_;
        this.m_38897_((Slot)new GemSlot(inventory, 0, 44, 53));
        this.m_38897_((Slot)new GemSlot(inventory, 1, 44, 35));
        this.m_38897_((Slot)new GemSlot(inventory, 2, 44, 17));
        this.m_38897_((Slot)new GemSlot(inventory, 3, 62, 17));
        this.m_38897_((Slot)new GemSlot(inventory, 4, 80, 17));
        this.m_38897_((Slot)new GemSlot(inventory, 5, 98, 17));
        this.m_38897_((Slot)new GemSlot(inventory, 6, 116, 17));
        this.m_38897_((Slot)new GemSlot(inventory, 7, 116, 35));
        this.m_38897_((Slot)new GemSlot(inventory, 8, 116, 53));
        this.m_38897_((Slot)new CatalystSlot(inventory, 9, 80, 43));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(forgeData);
    }

    public void m_6951_(boolean placeAll, Recipe<?> recipe, ServerPlayer player) {
        new GemForgeServerRecipePlacer<Container>(this).place(player, recipe, placeAll);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
        this.m_38946_();
    }

    public void m_5816_(StackedContents itemHelperIn) {
        if (this.forgeInventory instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.forgeInventory).m_5809_(itemHelperIn);
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 10; ++i) {
            this.forgeInventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super Container> recipeIn) {
        SimpleContainer inventory = new SimpleContainer(10);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            inventory.m_6836_(i, this.forgeInventory.getStackInSlot(i));
        }
        return recipeIn.m_5818_((Container)inventory, this.world);
    }

    public int m_6636_() {
        return 9;
    }

    public int m_6635_() {
        return 4;
    }

    public int m_6656_() {
        return 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_6653_() {
        return 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isForgeActive() {
        return this.forgeData.m_6413_(0) == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getForgeTimeScaled() {
        int i = this.forgeData.m_6413_(3);
        if (i == 0) {
            i = 200;
        }
        return this.forgeData.m_6413_(2) * 20 / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isRecipeValid() {
        return this.forgeData.m_6413_(1) == 1;
    }

    public void setForgeActive(boolean active) {
        this.forgeData.m_8050_(0, active ? 1 : 0);
    }

    public RecipeBookType m_5867_() {
        return RecipeBookType.valueOf((String)"GEM_FORGE");
    }

    public boolean m_142157_(int slot) {
        return slot != this.m_6636_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 10 ? !this.m_38903_(itemstack1, 10, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 10, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    class GemSlot
    extends SlotItemHandler {
        public GemSlot(ItemStackHandler inventoryIn, int index, int xIn, int yIn) {
            super((IItemHandler)inventoryIn, index, xIn, yIn);
        }

        public boolean m_5857_(ItemStack stack) {
            return true;
        }

        public int m_6641_() {
            return 1;
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            return 1;
        }
    }

    class CatalystSlot
    extends SlotItemHandler {
        public CatalystSlot(ItemStackHandler inventoryIn, int index, int xIn, int yIn) {
            super((IItemHandler)inventoryIn, index, xIn, yIn);
        }

        public boolean m_5857_(ItemStack stack) {
            return true;
        }

        public int m_6641_() {
            return 1;
        }

        public int m_5866_(@Nonnull ItemStack stack) {
            return 1;
        }
    }
}

