/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.enchantments;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.infernalstudios.miningmaster.access.LivingEntityAccess;
import org.infernalstudios.miningmaster.init.MMEnchantments;

public class GraceEnchantment
extends Enchantment {
    public GraceEnchantment(Enchantment.Rarity rarityIn, EquipmentSlot ... slots) {
        super(rarityIn, EnchantmentCategory.ARMOR_CHEST, slots);
    }

    public int m_6183_(int enchantmentLevel) {
        return 20;
    }

    public int m_6175_(int enchantmentLevel) {
        return 50;
    }

    public int m_6586_() {
        return 5;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6081_(ItemStack stack) {
        return this.f_44672_.m_7454_(stack.m_41720_()) || stack.canApplyAtEnchantingTable((Enchantment)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Player playerEntity = null;
        if (livingEntity instanceof Player) {
            playerEntity = (Player)livingEntity;
        }
        Random rand = new Random();
        ItemStack stack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        ListTag nbtList = stack.m_41785_();
        if (livingEntity.m_20069_()) {
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.GRACE.getId().toString())) continue;
                if (livingEntity.m_21023_(MobEffects.f_19593_) && playerEntity != null && !playerEntity.m_7500_() && rand.nextInt(80) == 0) {
                    stack.m_41622_(1, livingEntity, onBroken -> onBroken.m_21166_(EquipmentSlot.CHEST));
                }
                if (!((LivingEntityAccess)livingEntity).getGraceRecharged()) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 100 * idTag.m_128451_("lvl")));
                ((LivingEntityAccess)livingEntity).setGraceRecharged(false);
            }
        } else if (!livingEntity.m_20069_() && livingEntity.m_20096_() && !((LivingEntityAccess)livingEntity).getGraceRecharged()) {
            ((LivingEntityAccess)livingEntity).setGraceRecharged(true);
        }
    }
}

