/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.enchantments;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.infernalstudios.miningmaster.init.MMEnchantments;

public class HeartfeltEnchantment
extends Enchantment {
    public HeartfeltEnchantment(Enchantment.Rarity rarityIn, EquipmentSlot ... slots) {
        super(rarityIn, EnchantmentCategory.ARMOR, slots);
    }

    public int m_6183_(int enchantmentLevel) {
        return 20;
    }

    public int m_6175_(int enchantmentLevel) {
        return 50;
    }

    public int m_6586_() {
        return 2;
    }

    public boolean m_6081_(ItemStack stack) {
        return this.f_44672_.m_7454_(stack.m_41720_()) || stack.canApplyAtEnchantingTable((Enchantment)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity user = event.getEntity();
        Iterable equipment = user.m_20158_();
        for (ItemStack item : equipment) {
            ListTag nbtList = item.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.HEARTFELT.getId().toString())) continue;
                item.m_220157_(idTag.m_128451_("lvl"), user.m_217043_(), null);
            }
        }
    }

    @SubscribeEvent
    public static void onItemAttributeModifierCalculate(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        EquipmentSlot equipmentSlotType = null;
        if (itemStack.m_41720_() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)itemStack.m_41720_();
            equipmentSlotType = armorItem.m_40402_();
        }
        if (equipmentSlotType != null && event.getSlotType().equals(equipmentSlotType)) {
            ListTag nbtList = itemStack.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.HEARTFELT.getId().toString())) continue;
                if (equipmentSlotType.equals((Object)EquipmentSlot.HEAD)) {
                    event.addModifier(Attributes.f_22276_, new AttributeModifier(UUID.fromString("ccac859c-0311-43d4-b254-572d7846a5be"), "heartfelt", 2.0 * (double)idTag.m_128451_("lvl"), AttributeModifier.Operation.ADDITION));
                    continue;
                }
                if (equipmentSlotType.equals((Object)EquipmentSlot.CHEST)) {
                    event.addModifier(Attributes.f_22276_, new AttributeModifier(UUID.fromString("9dcfe3cf-7d9a-41c4-90de-84ff86b8b7c3"), "heartfelt", 2.0 * (double)idTag.m_128451_("lvl"), AttributeModifier.Operation.ADDITION));
                    continue;
                }
                if (equipmentSlotType.equals((Object)EquipmentSlot.LEGS)) {
                    event.addModifier(Attributes.f_22276_, new AttributeModifier(UUID.fromString("24572f77-4a5c-44a1-b6fa-09fc5da661b8"), "heartfelt", 2.0 * (double)idTag.m_128451_("lvl"), AttributeModifier.Operation.ADDITION));
                    continue;
                }
                event.addModifier(Attributes.f_22276_, new AttributeModifier(UUID.fromString("031a1eac-7726-46d6-87d7-cec65a66186b"), "heartfelt", 2.0 * (double)idTag.m_128451_("lvl"), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @SubscribeEvent
    public static void onItemUnequip(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_21223_() > livingEntity.m_21233_()) {
            livingEntity.m_21153_(livingEntity.m_21233_());
        }
    }
}

