/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.enchantments;

import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.infernalstudios.miningmaster.init.MMEnchantments;

public class RunnerEnchantment
extends Enchantment {
    public RunnerEnchantment(Enchantment.Rarity rarityIn, EquipmentSlot ... slots) {
        super(rarityIn, EnchantmentCategory.ARMOR_FEET, slots);
    }

    public int m_6183_(int enchantmentLevel) {
        return 20;
    }

    public int m_6175_(int enchantmentLevel) {
        return 50;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6081_(ItemStack stack) {
        return this.f_44672_.m_7454_(stack.m_41720_()) || stack.canApplyAtEnchantingTable((Enchantment)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return false;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }

    @SubscribeEvent
    public static void onItemAttributeModifierCalculate(ItemAttributeModifierEvent event) {
        if (event.getSlotType().equals((Object)EquipmentSlot.FEET)) {
            ItemStack itemStack = event.getItemStack();
            ListTag nbtList = itemStack.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.RUNNER.getId().toString())) continue;
                event.addModifier(Attributes.f_22279_, new AttributeModifier(UUID.fromString("047c6331-d618-4cc8-99c0-328e42d33b5e"), "runner", 0.2 * (double)idTag.m_128451_("lvl"), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Player playerEntity = null;
        if (livingEntity instanceof Player && (playerEntity = (Player)livingEntity).m_7500_()) {
            return;
        }
        Random rand = new Random();
        if (playerEntity != null && playerEntity.m_20142_()) {
            ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.FEET);
            ListTag nbtList = stack.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.RUNNER.getId().toString()) || rand.nextInt(100) != 0) continue;
                stack.m_41622_(1, livingEntity, onBroken -> onBroken.m_21166_(EquipmentSlot.FEET));
            }
        }
    }
}

