/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.init;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.infernalstudios.miningmaster.MiningMaster;
import org.infernalstudios.miningmaster.init.MMTags;

public class MMLootModifiers {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"miningmaster");
    public static final RegistryObject<Codec<SmeltingEnchantmentLootModifier>> SMELTING_ENCHANTMENT_LOOT_MODIFIER = LOOT_MODIFIERS.register("smelting_enchantment_loot_modifier", () -> SmeltingEnchantmentLootModifier.CODEC);
    public static final RegistryObject<Codec<StonebreakerEnchantmentLootModifier>> STONEBREAKER_ENCHANTMENT_LOOT_MODIFIER = LOOT_MODIFIERS.register("stonebreaker_enchantment_loot_modifier", () -> StonebreakerEnchantmentLootModifier.CODEC);

    public static void register(IEventBus eventBus) {
        LOOT_MODIFIERS.register(eventBus);
        MiningMaster.LOGGER.info("Mining Master: Loot Modifiers Registered!");
    }

    private static class StonebreakerEnchantmentLootModifier
    extends LootModifier {
        public static final Codec<StonebreakerEnchantmentLootModifier> CODEC = RecordCodecBuilder.create(inst -> StonebreakerEnchantmentLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, StonebreakerEnchantmentLootModifier::new));

        protected StonebreakerEnchantmentLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.removeIf(item -> item.m_204117_(MMTags.Items.STONEBREAKER_ITEMS));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }

    private static class SmeltingEnchantmentLootModifier
    extends LootModifier {
        public static final Codec<SmeltingEnchantmentLootModifier> CODEC = RecordCodecBuilder.create(inst -> SmeltingEnchantmentLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SmeltingEnchantmentLootModifier::new));

        protected SmeltingEnchantmentLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            for (ItemStack item : generatedLoot) {
                ItemStack itemstack;
                Optional optional = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{item}), (Level)context.m_78952_());
                if (!optional.isPresent() || (itemstack = ((SmeltingRecipe)optional.get()).m_8043_()).m_41619_()) continue;
                ItemStack itemstack1 = itemstack.m_41777_();
                itemstack1.m_41764_(item.m_41613_() * itemstack.m_41613_());
                generatedLoot.add((Object)itemstack1);
                generatedLoot.remove((Object)item);
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }
    }
}

