/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.mixin;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.infernalstudios.miningmaster.init.MMEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class MixinAbstractArrow {
    private int freezingLevel = 0;
    private int floatingLevel = 0;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void MM_setEnchantsOnCreation(EntityType entityType, LivingEntity shooter, Level level, CallbackInfo ci) {
        int freezing = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)MMEnchantments.FREEZING.get()), (LivingEntity)shooter);
        int floating = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)MMEnchantments.FLOATATION.get()), (LivingEntity)shooter);
        if (freezing > 0) {
            this.freezingLevel = freezing;
        }
        if (floating > 0) {
            this.floatingLevel = floating;
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;doPostHurtEffects(Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void MM_dealArrowEnchants(EntityHitResult hitResult, CallbackInfo ci) {
        LivingEntity livingEntity;
        Entity entity;
        if (this.freezingLevel > 0 && (entity = hitResult.m_82443_()) instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (!livingEntity.f_19853_.m_5776_() && !livingEntity.m_21224_()) {
                livingEntity.m_146917_(Math.max(livingEntity.m_146888_(), livingEntity.m_146891_() + 120 * this.freezingLevel));
            }
        }
        if (this.floatingLevel > 0 && (entity = hitResult.m_82443_()) instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 4 * this.floatingLevel));
        }
    }
}

