/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.infernalstudios.miningmaster.access.LivingEntityAccess;
import org.infernalstudios.miningmaster.init.MMEnchantments;
import org.infernalstudios.miningmaster.network.DamageKnightJumpPacket;
import org.infernalstudios.miningmaster.network.MMNetworkHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements LivingEntityAccess {
    private int knightJumpsUsed = 0;
    @Unique
    private static final EntityDataAccessor<Boolean> GRACE_RECHARGED = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    protected abstract void m_6135_();

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void MM_countTicksFalling(CallbackInfo ci) {
        if (this.f_19861_) {
            this.knightJumpsUsed = 0;
        }
    }

    public MixinLivingEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void useKnightJump() {
        if (!this.f_19861_) {
            boolean hasKnightJump = false;
            int level = 0;
            ItemStack stack = this.m_6844_(EquipmentSlot.LEGS);
            if (stack.m_150930_(Items.f_41852_)) {
                return;
            }
            ListTag nbtList = stack.m_41785_();
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag idTag = nbtList.m_128728_(i);
                if (!idTag.m_128461_("id").equals(MMEnchantments.KNIGHT_JUMP.getId().toString())) continue;
                hasKnightJump = true;
                level = idTag.m_128451_("lvl");
            }
            if (hasKnightJump && this.knightJumpsUsed < level) {
                ++this.knightJumpsUsed;
                MMNetworkHandler.sendToServer(new DamageKnightJumpPacket(1));
                this.m_6135_();
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData"})
    private void MM_registerData(CallbackInfo ci) {
        ((LivingEntity)this).m_20088_().m_135372_(GRACE_RECHARGED, (Object)true);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    private void MM_writeAdditionalData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("GraceRecharged", ((Boolean)((LivingEntity)this).m_20088_().m_135370_(GRACE_RECHARGED)).booleanValue());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    private void MM_readAdditionalData(CompoundTag compound, CallbackInfo ci) {
        this.setGraceRecharged(compound.m_128471_("GraceRecharged"));
    }

    @Override
    public void setGraceRecharged(boolean isGraceRecharged) {
        ((LivingEntity)this).m_20088_().m_135381_(GRACE_RECHARGED, (Object)isGraceRecharged);
    }

    @Override
    public boolean getGraceRecharged() {
        return (Boolean)((LivingEntity)this).m_20088_().m_135370_(GRACE_RECHARGED);
    }
}

