/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.miningmaster.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DamageKnightJumpPacket {
    private final int damage;

    public DamageKnightJumpPacket(int damage) {
        this.damage = damage;
    }

    public static void encode(DamageKnightJumpPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.damage);
    }

    public static DamageKnightJumpPacket decode(FriendlyByteBuf buffer) {
        return new DamageKnightJumpPacket(buffer.readInt());
    }

    public static void handle(DamageKnightJumpPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer playerEntity = ((NetworkEvent.Context)context.get()).getSender();
            if (playerEntity != null) {
                ItemStack stack = playerEntity.m_6844_(EquipmentSlot.LEGS);
                stack.m_41622_(message.damage, (LivingEntity)playerEntity, onBroken -> onBroken.m_21166_(EquipmentSlot.LEGS));
            }
        });
        context.get().setPacketHandled(true);
    }
}

